# Environment ID
resource "random_string" "cluster_id" {
  length = 8
  special = false
  upper = false
}

module "hub" {
  source                      = "hub/environment"
  application_name            = "${var.hub_application_name}"
  environment                 = "${var.environment}"
  cluster_id                  = "${random_string.cluster_id.result}"
  sns_arn                     = "${var.hub_sns_arn}"
  configuration_template_name = "${var.hub_configuration_template_name}"
  env_health_threshold        = "${var.hub_env_health_threshold}"
  cw_es_shipper_lambda_name   = "${var.cw_es_shipper_lambda_name}"
  subnets                     = "${var.node_subnets}"
  vpc_id                      = "${var.vpc_id}"
  enable_vpc_endpoint         = "${var.enable_hub_vpc_endpoint}"
  elb_managed_security_group  = "${var.hub_elb_managed_security_group}"
  se_major_version            = "${var.se_major_version}"
  alarms_enabled              = "${var.alarms_enabled}"
}

module "nodes" {
  source      = "windows_10"
  name        = "grid-win10-node"
  count       = "${var.node_count}"
  environment = "${var.node_environment}"
  cluster_id  = "${random_string.cluster_id.result}"
  ami         = "${var.node_ami}"
  se_major_version = "${var.se_major_version}"
  instance_profile = "${var.node_instance_profile_name}"
  instance_type    = "${var.node_instance_type}"
  tenancy = "dedicated"
  git_branch_name = "${var.node_branch}"
  AutoLaunchGrid  = "${var.auto_launch_grid}"
  DesktopAppSupport   = "${var.desktopAppSupport}"
  ChromeDriverVersion = "${var.chromedriver_version}"
  hub_fqdn = "${module.hub.cname}"
  subnet_id = "${var.node_subnets}"
  security_groups = ["${var.node_security_groups}"]
  asg_suspended_processes = "${var.node_asg_suspended_processes}"
  sns_arn_low  = "${var.node_sns_arn_low}"
  sns_arn_high = "${var.node_sns_arn_high}"
}
