variable "node_count" {} // Number of Selenium Nodes to launch in the Cluster
variable "hub_configuration_template_name" {} // The Hub configuration template to use for the environment
variable "hub_application_name" {} // The Beanstalk application name for the Grid Hub
variable "node_instance_profile_name" {} // The Node's Instance Profile Name
variable "hub_sns_arn" {} // The SNS Alarm for Hubs
variable "node_sns_arn_high" {} // The SNS Alarm for Nodes, High Priority
variable "node_sns_arn_low" {} // The SNS Alarm for Nodes, Low Priority
variable "cw_es_shipper_lambda_name" {} // The Lambda Name used for shipping Cloudwatch Logs to Elasticsearch
variable "vpc_id" {} // VPC to launch resources into
variable "node_subnets" { // A list of subnets to place nodes into
  type = "list"
}
variable "environment" { // The environment that's being launched into
  default = "prod"
}
variable "node_environment" { // TODO: Remove this and just use one environment. Added this as the -2xl env shows as just "prod"
  default = "prod"
}
variable "node_branch" { // The git branch to run for the nodes
  default = "master"
}
variable "se_major_version" { // The major version of Selenium to use (3, 4, etc.)
  default = "3"
}
variable "node_ami" { // The AMI to launch the node with
  default = "ami-01b5623fc8a7f21a3"
}
variable "auto_launch_grid" { // Whether to launch Grid on boot
  default = "true"
}
variable "chromedriver_version" { // The version of Chromedriver to run
  default = ""
}
variable "node_instance_type" { // The instance type to run the nodes in
  default = "c4.xlarge"
}
variable "desktopAppSupport" { // Whether to support desktop applications
  default = "false"
}
variable "node_asg_suspended_processes" { // https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-suspend-resume-processes.html#choosing-suspend-resume
  type = "list"
  default = ["AZRebalance"]
}
variable "node_security_groups" { // Security Groups to attach to the nodes
  type = "list"
  default = []
}

/*
The threshold of the Hub Beanstalk Environment at which it alarms
0 (Ok), 1 (Info), 5 (Unknown), 10 (No data), 15 (Warning), 20 (Degraded), 25 (Severe)
*/
variable "hub_env_health_threshold" {
  default = "20"
}

variable "enable_hub_vpc_endpoint" {
  default = true
}

// Enable Cloudwatch Alarms
variable "alarms_enabled" {
  default = true
}

// This is a security group Beanstalk may automatically modify to allow permissions
// DO NOT pass something like twitch_subnets to this. Beanstalk may modify that
variable "hub_elb_managed_security_group" {
  type = "string"
  default = ""
}
