job {
    name "grid-companion-build"
    using 'TEMPLATE-autobuild'

    logRotator {
      daysToKeep(90)
    }

    scm {
      git {
        remote {
          github 'qe/grid_companion', 'ssh', 'git.xarth.tv'
          credentials 'git-aws-read-key'
        }
        clean true
      }
    }
    wrappers {
      colorizeOutput(colorMap = 'xterm')
      timestamps()
    }
    steps {
      shell 'manta -v'
    }
    publishers {
      archiveJunit('.manta/test_report.xml')
    }
}
