package main

import (
	"code.justin.tv/qe/grid_companion/pkg/companion"
	"code.justin.tv/qe/grid_companion/pkg/config"
	"log"
)

func main() {
	config := config.Config{}
	err := config.Init()
	if err != nil {
		log.Fatalf("Error initializing configuration. Error: %v", err)
	}

	log.Printf("Grid Companion Application Loaded.")

	// Create an object that will report the hub's capacity to the Grid Router
	reporter := companion.Reporter{}
	reporter.Init(&config)

	// Infinitely Poll the status of hub and report it to router
	reporter.PollStatusAndReport()
}
