package services

import (
	"fmt"
	"github.com/stretchr/testify/assert"
	"net/http"
	"net/http/httptest"
	"testing"
)

func TestHub_Init(t *testing.T) {
	testProtocol := "http"
	testBase := "www.testhub.com"

	expectedURL := fmt.Sprintf("%s://%s%s", testProtocol, testBase, hubEndpoint)

	expectedHub := Hub3{
		URL: &expectedURL,
	}

	actualHub := Hub3{}
	actualHub.Init(testProtocol, testBase)
	assert.Equal(t, expectedHub, actualHub)
}

func TestHub_Get(t *testing.T) {
	/*
	Should return the proper free slots
	 */
	expectedFreeSlots := 0
	expectedTotalSlots := 10

	apiStub := httptest.NewServer(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		fmt.Fprintf(w, "{\"slotCounts\": {\"free\": %d, \"total\": %d}}", expectedFreeSlots, expectedTotalSlots)
	}))
	defer apiStub.Close()

	expectedResponse := HubOutput{
		SlotCounts: SlotCounts{Free: expectedFreeSlots, Total: expectedTotalSlots,},
	}

	hub := Hub3{URL: &apiStub.URL}
	actualResponse, err := hub.Get()
	assert.NoError(t, err)
	assert.Equal(t, &expectedResponse, actualResponse)

	/*
	Returns an error when the http server returns an error
	 */
	errCode := 500
	errMsg := "unexpected error"
	apiStubErr := httptest.NewServer(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		http.Error(w, errMsg, errCode)
	}))

	hub = Hub3{URL: &apiStubErr.URL}
	actualResponse, err = hub.Get()
	assert.Error(t, err)
	assert.EqualError(t, err,
		fmt.Sprintf("The hub returned an unexpected response. Status Code: %d Body: %s\n", errCode, errMsg))

	/*
	Returns an error when URL is nil
	 */

	 hub = Hub3{}
	 _, err = hub.Get()
	 assert.Error(t, err)
	 assert.EqualError(t, err, "the Hub URL was not set")
}
