package services

import (
	"context"
	"errors"
	"fmt"
	"github.com/shurcooL/graphql"
)

// Provides a service connection to the Hub
type Hub4 struct {
	URL    string
	client GraphQLClient
}

// Initializes a Hub connection
func (h *Hub4) Init(protocol string, baseURL string) {
	fullUrl := fmt.Sprintf("%s://%s/graphql", protocol, baseURL)
	h.URL = fullUrl
	h.client = graphql.NewClient(fullUrl, nil)
}

// Gets the status from the Hub API
func (h *Hub4) Get() (*HubOutput, error) {
	var hubStatus HubOutput

	// If the URL wasn't set, return
	if h.client == nil {
		return nil, errors.New("the graphql client is nil")
	}

	// Create a struct that describes the query we make. GQL Client will populate these with the response
	var query struct {
		Grid struct {
			SessionCount graphql.Int
			MaxSession   graphql.Int
		}
	}

	err := h.client.Query(context.Background(), &query, nil)
	if err != nil {
		return &hubStatus, fmt.Errorf("encountered error from graphql: %v", err)
	}

	hubStatus.SlotCounts = SlotCounts{
		Free: int(query.Grid.MaxSession) - int(query.Grid.SessionCount),
		Total: int(query.Grid.MaxSession),
	}

	return &hubStatus, nil
}
