package services

import (
	"code.justin.tv/qe/grid_companion/pkg/services/mocks"
	"errors"
	"fmt"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/mock"
	"testing"
)

func TestHub4_Init(t *testing.T) {
	t.Run("initializes with expected attributes", func (t *testing.T) {
		protocol := "http"
		base := "testgrid.fake"
		expectedURL := fmt.Sprintf("%s://%s/graphql", protocol, base)

		hub := Hub4{}
		hub.Init(protocol, base)

		assert.Equal(t, expectedURL, hub.URL)
		assert.NotNil(t, hub.client)
	})
}

func TestHub4_Get(t *testing.T) {
	mockGQLClient := &mocks.GraphQLClient{}
	hub := Hub4{
		URL: "testgrid.fake",
		client: mockGQLClient,
	}

	t.Run("when query is successful", func (t *testing.T) {
		mockGQLClient.On("Query", mock.Anything, mock.Anything, mock.Anything).Return(nil).Once()
		resp, err := hub.Get()
		assert.NoError(t, err)
		assert.NotNil(t, resp)
	})

	t.Run("when query returns an error", func (t *testing.T) {
		mockErr := "test error with gql query"
		mockGQLClient.On("Query", mock.Anything, mock.Anything, mock.Anything).Return(
			errors.New(mockErr)).Once()
		resp, err := hub.Get()
		assert.EqualError(t, err, fmt.Sprintf("encountered error from graphql: %s", mockErr))
		assert.NotNil(t, resp)
	})
}
