# Grid Healthcheck

Grid Healthcheck is an application that ensures sessions can be created on Grid, and opens a PagerDuty incident if there was a problem.

It's written in Go, and runs on AWS Lambda.

## Configuration

### Environment Variables
| Name | Default | Description |
|----------|----------|--------|
| BROWSER | chrome | The browser to launch the healthcheck against

## Architecture
I chose to run this on Lambda, as I wanted to prevent an issue where the actual health check machine went down.

I chose to develop this in Go, as some of our other Grid projects will be in Go. It's also supported by AWS Lambda.

## Developing

Ensure you have installed Go. You can follow [these steps](https://golang.org/doc/install), or install it via Homebrew:
```
brew update
brew install go
```

Then, ensure this repository is on your $GOPATH. For example: `~/go/src/twitch/qe/grid_healthcheck`

### Local Development
You cannot just run this locally, as it's designed for Lambda.

To run locally, within the main function, comment out:
```
lambda.Start(runHealthCheck)
```

and uncomment:
```
runHealthCheck()
```

To run, on your command line, type:
```
go run main.go
```

### Deploying Update to Lambda
If you update the code, be sure to send it to Lambda.

Run this script:
```
./build.sh
```

Then, run terraform:
```
cd terraform
terraform plan
```

You should see only the source_code_hash change, like:
```
~ aws_lambda_function.grid-healthcheck
    source_code_hash: "7Fmu83kO3VVZ4x9xg9ThBwaHiAkO2JxGO0E6TaoHzbE=" => "WefaL46LPaUzgp0oyDjaK99c3QOzVYDoUX74hpKU67o="


Plan: 0 to add, 1 to change, 0 to destroy.
```

If it looks similar, then apply the change:
```
terraform apply
```

# Future Improvements
1) Support supplying a URL via an environment variable
2) Support supplying the pagerduty service key as an environment variable
3) Close opened incidents when the website becomes available again
