package main

import (
	"github.com/stretchr/testify/assert"
	"os"
	"testing"
)

func TestNewConfig(t *testing.T) {
	t.Run("BROWSER", func (t *testing.T) {
		t.Run("uses the default if not provided", func (t *testing.T) {
			config := NewConfig()
			assert.Equal(t, defaultBrowser, config.Browser)
		})

		t.Run("accepts the user specified browser env variable", func (t *testing.T) {
			testBrowser := "myTestBrowser"
			os.Setenv("BROWSER", testBrowser)
			defer os.Unsetenv("BROWSER")
			config := NewConfig()
			assert.Equal(t, testBrowser, config.Browser)
		})
	})
}
