package main

import (
	"fmt"
	"github.com/stretchr/testify/assert"
	"io/ioutil"
	"net/http"
	"strings"
	"testing"
)

func TestCheckRequestStatus(t *testing.T) {
	/*
	Returns no error if successful
	 */
	respBody := "success"
	resp := &http.Response{
		Body: ioutil.NopCloser(strings.NewReader(respBody)),
		StatusCode: 200,
	}
	err := checkRequestStatus(resp)
	assert.NoError(t, err)

	/*
	Returns the error code and the response body when a failure
	 */
	respBody = "this is a test error"
	resp = &http.Response{
		Body: ioutil.NopCloser(strings.NewReader(respBody)),
		StatusCode: 500,
	}
	err = checkRequestStatus(resp)
	assert.Error(t, err)
	assert.EqualError(t, err, fmt.Sprintf("Unexpected Status Code: %d. Response Body: %s", 500, respBody))
}
