variable "pd_service" { // https://twitchoncall.pagerduty.com/services/PCTMKGR
  default = "https://events.pagerduty.com/integration/bc868c2b1a1842858d35c0501a4e2c53/enqueue"
}

resource "aws_sns_topic" "healthcheck" {
  name = "selenium-grid-healthcheck"
}

resource "aws_sns_topic_subscription" "pagerduty" {
  topic_arn = "${aws_sns_topic.healthcheck.arn}"
  protocol  = "https"
  endpoint  = "${var.pd_service}"
  endpoint_auto_confirms = true
}

// Triggers alarm whenever the Grid Healthcheck Lambda fails
resource "aws_cloudwatch_metric_alarm" "failures" {
  alarm_name                = "${aws_lambda_function.grid_healthcheck.function_name}_errors"
  comparison_operator       = "GreaterThanOrEqualToThreshold"
  evaluation_periods        = "1"
  metric_name               = "Errors"
  namespace                 = "AWS/Lambda"
  period                    = "60"
  statistic                 = "Sum"
  threshold                 = "1"
  alarm_description         = "Grid Healthcheck Failure"
  insufficient_data_actions = ["${aws_sns_topic.healthcheck.arn}"]
  alarm_actions             = ["${aws_sns_topic.healthcheck.arn}"]
  ok_actions                = ["${aws_sns_topic.healthcheck.arn}"]

  dimensions = {
    FunctionName = "${aws_lambda_function.grid_healthcheck.function_name}"
    Resource     = "${aws_lambda_function.grid_healthcheck.function_name}"
  }
}
