resource "aws_lambda_function" "grid_healthcheck_firefox" {
  filename         = "../main.zip"
  function_name    = "grid-healthcheck-firefox"
  role             = "${aws_iam_role.iam_for_lambda.arn}"
  handler          = "main"
  source_code_hash = "${base64sha256(file("../main.zip"))}"
  runtime          = "go1.x"
  timeout          = "30"

  vpc_config {
    security_group_ids = ["${data.terraform_remote_state.vpc.twitch_subnets_sg}"] # Allow connection from all twitch infra
    subnet_ids = ["${data.terraform_remote_state.vpc.private_a}"] # Run on the private subnet
  }

  environment {
    variables = {
      BROWSER = "firefox"
    }
  }

  tags {
    Name = "Grid Healthcheck Firefox"
  }
}

############
# Triggers #
############

# The trigger, to fire every minute
resource "aws_cloudwatch_event_rule" "firefox" {
  name = "grid-healthcheck-firefox"
  description = "Health Check for Grid, Fires every 5 minutes"
  schedule_expression = "rate(5 minutes)"
}

# Connects the trigger to the lambda fucntion
resource "aws_cloudwatch_event_target" "firefox" {
  rule = "${aws_cloudwatch_event_rule.firefox.name}"
  arn = "${aws_lambda_function.grid_healthcheck_firefox.arn}"
}

# Gives lambda permission
resource "aws_lambda_permission" "firefox_cloudwatch" {
  statement_id = "AllowExecutionFromCloudWatch"
  action = "lambda:InvokeFunction" // Enable the event
  //  action = "lambda:DisableInvokeFunction" // Disable the event
  function_name = "${aws_lambda_function.grid_healthcheck_firefox.function_name}"
  principal = "events.amazonaws.com"
  source_arn = "${aws_cloudwatch_event_rule.firefox.arn}"
}

# Stores the results of the health check in a log
resource "aws_cloudwatch_log_group" "healthcheck_firefox" {
  name = "/aws/lambda/${aws_lambda_function.grid_healthcheck_firefox.function_name}"
  retention_in_days = "3"
}
