# grid_hub
Hub configuration for Cross Browser Grid

Builds a docker container for Selenium Hub, with customized software to suit Twitch's needs.

## Configuration

### Supported Environment Variables

#### Selenium Hub Configuration
These are the environment variables that help create a Hub's Configuration

| ENV Var Name | Default | Description
|---|---|---|
| GRID_MAX_SESSION | 5 | The maximum sessions for a node to receive. Not valid for Hub.
| GRID_NEW_SESSION_WAIT_TIMEOUT | -1 | How long to wait for a new session to be fulfilled
| GRID_THROW_ON_CAPABILITY_NOT_PRESENT | true | Unknown
| GRID_JETTY_MAX_THREADS | -1 | The maximum threads to create for jetty
| GRID_CLEAN_UP_CYCLE | 5000 | (ms) how long until a stale node should be removed
| GRID_BROWSER_TIMEOUT | 299 | maximum time a node is willing to hang inside the browser
| GRID_TIMEOUT | 300 | maximum time resources are reclaimed after a client crashes
| GRID_DEBUG | false | Whether to write debug log information
| GRID_HUB_PORT | 4444 | The port to run the hub on
| GRID_HUB_HOST | 0.0.0.0 | The host IP to run the hub

#### Custom Cross Browser Grid Configuration
These are the environment variables for customized Cross Browser Grid configuration

| ENV Var Name | Default | Description
|---|---|---|
| TRIGGER_PAGERDUTY_EVENTS | True | Whether to trigger PagerDuty Events on WARN/SEVERE
| CBG_RUN_COMPANION | true | Whether to run the CBG Companion Application
| CBG_COMPANION_ROUTER_URL | NONE - REQUIRED | The Grid Router associated with the hub environment
| CBG_COMPANION_HUB_EXTERNAL_PORT | 80 | The Grid Router's port associated with the hub environment
| CBG_COMPANION_POLL_WAIT | 5 | The amount of time between sending the Hub's status to the Grid Router

### PagerDuty
By default, WARNING/ERROR logs will be reported to PagerDuty.
You can disable this via an environment variable when using `docker run`:
```
-e TRIGGER_PAGERDUTY_EVENTS=false
```

## Server Architecture
Grid Hub is designed to run in a Docker Container. This is portable, so it can be ran in a variety of environments.

We've recently moved to Elastic Beanstalk to run the docker container.
This is to help with the deployment process in which EB will automatically build the latest container, instead of our deploys having to manage versions.

Historically we ran on bare-ec2, but depended on puppet to start the docker container. This became painful to maintain.

## Local Development

### Build

These steps will build the docker container:
1) `docker build -t qe/grid_hub .`
2) `docker run qe/grid_hub:latest`

### Dependencies
This Docker requires the Selenium CBG Extensions JAR. This can be built following the [Extensions Readme](../../shared/selenium/extensions/README.md)

Then, move the cbg-extensions-jar-with-dependencies.jar from src/shared/selenium/extensions/cbg_bin into this folder.

## Resources
Influenced by [this url](https://github.com/SeleniumHQ/docker-selenium/tree/master/Hub).
