#!/bin/bash

# Check if user requested NOT to run the companion program
if [ "$CBG_RUN_COMPANION" != true ]; then
  echo "User specified not to run companion program"
  exit 0
fi

# Get Region Data
EC2_AVAIL_ZONE=`curl -s http://169.254.169.254/latest/meta-data/placement/availability-zone`
EC2_REGION="`echo \"$EC2_AVAIL_ZONE\" | sed 's/[a-z]$//'`"

# Get Instance ID
INSTANCE_ID=$(wget -T 5 -q -O - http://169.254.169.254/latest/meta-data/instance-id)
if [ -z "$INSTANCE_ID" ]; then
    echo "ERROR: Instance ID could not be found"
    exit 1
else
    echo "The Companion Instance ID: $INSTANCE_ID"
fi

AWS_IP=$(wget -T 5 -q -O - http://169.254.169.254/latest/meta-data/local-ipv4)
if [ -z "$AWS_IP" ]; then
    echo "ERROR: The AWS IP could not be found"
else
  echo "The Companion AWS ID: $AWS_IP"
fi

CLUSTER_ID=$(aws ec2 describe-tags --region "$EC2_REGION" --filters \
  "Name=resource-type,Values=instance" \
  "Name=resource-id,Values=$INSTANCE_ID" \
  "Name=key,Values=GridClusterID" \
  --query "Tags[0].Value" | tr -d '"') # Remove quotes that aws cli returns

if [ -z "$CLUSTER_ID" ] || [ "$CLUSTER_ID" = "null" ]; then
  echo "ERROR: The Cluster ID could not be read"
  exit 1
else
  echo "The Cluster ID: $CLUSTER_ID"
fi

CLUSTER_ENV=$(aws ec2 describe-tags --region "$EC2_REGION" --filters \
  "Name=resource-type,Values=instance" \
  "Name=resource-id,Values=$INSTANCE_ID" \
  "Name=key,Values=Environment" \
  --query "Tags[0].Value" | tr -d '"') # Remove quotes that aws cli returns

if [ -z "$CLUSTER_ENV" ] || [ "$CLUSTER_ENV" = "null" ]; then
  echo "ERROR: The Cluster Environment could not be read"
  exit 1
else
  echo "The Cluster Environment: $CLUSTER_ENV"
fi

ENV_HOSTNAME="hub-$CLUSTER_ENV-$CLUSTER_ID.browsergrid.twitch.a2z.com"

SE_MAJOR_VERSION=$(aws ec2 describe-tags --region "$EC2_REGION" --filters \
  "Name=resource-type,Values=instance" \
  "Name=resource-id,Values=$INSTANCE_ID" \
  "Name=key,Values=SeMajorVersion" \
  --query "Tags[0].Value" | tr -d '"') # Remove quotes that aws cli returns

# Determine if the Hub's Status should be queried using GraphQL
# This is only supported in Selenium 4.0 (the latest version as of today)
USE_GQL="false" # initialize as false as the default
if [ "$SE_MAJOR_VERSION" = "4" ]; then
  USE_GQL="true"
fi

sleep 5 # Give the hub a bit to boot

/opt/cbg_companion -id "$INSTANCE_ID" -hubIntIP "$GRID_HUB_HOST" -hubIntPort "$GRID_HUB_PORT" \
  -hubExtIP "$AWS_IP" -hubExtPort "$CBG_COMPANION_HUB_EXTERNAL_PORT" -hubClusterName "$CLUSTER_ID" \
  -hubHostname "$ENV_HOSTNAME" -routerUrl "$CBG_COMPANION_ROUTER_URL" -pollWait "$CBG_COMPANION_POLL_WAIT" \
  -graphQL="$USE_GQL"
