#!/bin/bash

# Launcher for Selenium Grid 3.x

ROOT=/opt/selenium_3
CONF=${ROOT}/config.json
CAPABILITY_MATCHER="com.cbg.selenium.capability_matcher.CBGCapabilityMatcher"
LOGGING_CONFIG_FILE="$ROOT/selenium_logging.config"
CBG_CONFIG_FILE="$ROOT/cbg_config.yaml"

# Replace Logging with Proper Instance ID
INSTANCE_ID=$(wget -T 5 -q -O - http://169.254.169.254/latest/meta-data/instance-id)
echo "The Instance ID: $INSTANCE_ID"
sed -i "s/REPLACE_INSTANCE_ID/$INSTANCE_ID/g" $CBG_CONFIG_FILE

# set -e: exit asap if a command exits with a non-zero status
# Doing it after the Instance ID Check, incase this is running on a non-aws machine
set -e

# Determine PagerDuty Events Triggering
# Defaults to True if user did not provide
# This determines if errors in Grid should be triggered to PagerDuty
if [ ! -z "$TRIGGER_PAGERDUTY_EVENTS" ]; then # If env provided, set to that value
  echo "Setting PagerDuty Trigger Events to $TRIGGER_PAGERDUTY_EVENTS"
  sed -i "s/REPLACE_PAGERDUTY_TRIGGER_EVENTS/$TRIGGER_PAGERDUTY_EVENTS/g" $LOGGING_CONFIG_FILE
else # If not provided, default to true
  echo "User did not specify ENV TRIGGER_PAGERDUTY_EVENTS. Defaulting triggering events to true"
  sed -i "s/REPLACE_PAGERDUTY_TRIGGER_EVENTS/true/g" $LOGGING_CONFIG_FILE
fi

# Launch Selenium
/opt/bin/generate_config.sh >${CONF}

echo "Starting Selenium Hub with configuration:"
cat ${CONF}

if [ ! -z "$SE_OPTS" ]; then
  echo "Appending Selenium options: ${SE_OPTS}"
fi

cd "$ROOT"

java ${JAVA_OPTS} \
  -Djava.util.logging.config.file=$LOGGING_CONFIG_FILE \
  -Dcbg.config.path="$CBG_CONFIG_FILE" \
  -cp *:. org.openqa.grid.selenium.GridLauncherV3 \
  -role hub \
  -hubConfig $CONF \
  -capabilityMatcher $CAPABILITY_MATCHER \
  ${SE_OPTS}
