#!/bin/bash

# Launcher for Selenium Grid 4.x

set -e # exit immediately on error

# Find the Selenium 4.0 jar filepath using a regex
# Example: selenium-server-4.0.0-prerelease-beta-1-02d52641d5.jar
directory=/opt/selenium_4/
filepath=$(find "$directory" -regex '.*selenium-server-4.0.0.*\.jar' -type f)

echo "Launching Selenium 4.0 from $filepath"
java -jar "$filepath" hub --config "$directory/se4_config.toml"
