package main

import (
	"code.justin.tv/qe/grid_reboot/mocks"
	"errors"
	"fmt"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/service/elasticbeanstalk"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/mock"
	"testing"
)

func TestBeanstalkService_RestartHub(t *testing.T) {
	t.Run("returns nil if no error", func (t *testing.T) {
		envName := "mock-env"
		clusterName := "mock-cluster"
		appServerName := fmt.Sprintf("grid-hub-%s-%s", envName, clusterName)

		expectedInput := &elasticbeanstalk.RestartAppServerInput{
			EnvironmentName: aws.String(appServerName),
		}

		bsInterface := &mocks.BeanstalkInterface{}
		bsInterface.On("RestartAppServer", expectedInput).Return(&elasticbeanstalk.RestartAppServerOutput{}, nil).Once()

		bsService := &BeanstalkService{
			Service: bsInterface,
		}

		err := bsService.RestartHub(envName, clusterName)
		assert.NoError(t, err)
	})

	t.Run("returns err", func (t *testing.T) {
		envName := "mock-env"
		clusterName := "mock-cluster"
		expectedErr := "mock beanstalk error"

		bsInterface := &mocks.BeanstalkInterface{}
		bsInterface.On("RestartAppServer", mock.Anything).Return(&elasticbeanstalk.RestartAppServerOutput{},
		  errors.New(expectedErr)).Once()

		bsService := &BeanstalkService{
			Service: bsInterface,
		}

		err := bsService.RestartHub(envName, clusterName)
		assert.EqualError(t, err, expectedErr)
	})
}
