job {
    name "grid-reboot-build"
    using 'TEMPLATE-autobuild'

    logRotator {
      daysToKeep(90)
    }

    scm {
      git {
        remote {
          github 'qe/grid_reboot', 'ssh', 'git.xarth.tv'
          credentials 'git-aws-read-key'
        }
        clean true
      }
    }
    wrappers {
      credentialsBinding {
        usernamePassword('AWS_ACCESS_KEY_ID', 'AWS_SECRET_ACCESS_KEY', 'twitch-cape-qe-aws')
      }
      colorizeOutput(colorMap = 'xterm')
      timestamps()
    }
    steps {
      shell './scripts/jenkins_build.sh'
    }
    publishers {
      archiveJunit('.manta/test_report.xml')
    }
}
