#!/bin/bash
# This script is designed to run manta, which will run tests and output results and an artifact
# If the branch is master, it will build and release a new docker image

# Stop running on first error
set -e

DOCKER_REGISTRY="425992774280.dkr.ecr.us-west-2.amazonaws.com/grid_reboot"
LOCAL_DOCKER_IMAGE="grid_reboot"
DOCKER_IMAGE_VERSION="latest"

function main {
    # Run Manta
    manta -v

    if [ "$GIT_BRANCH" = "origin/master" ]; then # If the branch is master (Jenkins git plugin sets $GIT_BRANCH)
        buildDockerImage
        deployDockerImage
    else
        echo "Git branch was not master, so not deploying to docker. (Branch: $GIT_BRANCH)"
    fi
}

# Builds docker container
function buildDockerImage {
    echo "Building in Docker"
    docker build -t "$LOCAL_DOCKER_IMAGE:$DOCKER_IMAGE_VERSION" .
}

function deployDockerImage {
    echo "Deploying Docker Image"
    $(aws ecr get-login --no-include-email --region us-west-2)
    docker tag "$LOCAL_DOCKER_IMAGE:$DOCKER_IMAGE_VERSION" "$DOCKER_REGISTRY:$DOCKER_IMAGE_VERSION"
    docker push "$DOCKER_REGISTRY:$DOCKER_IMAGE_VERSION"
}

main
