#!/bin/bash

# This script is designed to run inside of the production docker container
# It reports execution result metrics to Cloudwatch

/go/src/code.justin.tv/qe/grid_reboot/grid_reboot
EXIT_CODE=$?

echo "Program Exited with code: $EXIT_CODE"

# Convert Exit Code to a metric value where 0 = Fail, 1 = Pass
if [ "$EXIT_CODE" -eq 0 ]; then
    metric_value=1
else
    metric_value=0 # Anything not exit code 0 is a fail
fi

# Build the metric data
metric_name="ExecutionResult"
metric_data="MetricName=$metric_name,Value=$metric_value,Unit=None"

# Report the execution result to Cloudwatch
echo "Reporting to CloudWatch, Metric Data: $metric_data"
aws cloudwatch put-metric-data --namespace "Grid Reboot" --metric-data "$metric_data"
