# Contains code related to the ECR (Docker registry for Grid Reboot)

variable "allowed_roles" {
  type = "list"
  default = [
    "arn:aws:iam::425992774280:role/GridRebootTaskExecutionRole", // cape-qe
    "arn:aws:iam::148380705220:role/GridRebootTaskExecutionRole", // twilight
    "arn:aws:iam::100860887800:role/GridRebootTaskExecutionRole", // beacon
    "arn:aws:iam::147030575244:role/GridRebootTaskExecutionRole", // twitch-browsergrid-prod
  ]
}

# Create an ECR to store the docker containers
resource "aws_ecr_repository" "GridReboot" {
  name = "grid_reboot"
  tags {
    Owner = "dylan"
  }
}

# Delete old images policy
resource "aws_ecr_lifecycle_policy" "GridDeleteImagePolicy" {
  repository = "${aws_ecr_repository.GridReboot.name}"

  policy = <<EOF
{
    "rules": [
        {
            "rulePriority": 1,
            "description": "Expire images older than 30 days",
            "selection": {
                "tagStatus": "untagged",
                "countType": "sinceImagePushed",
                "countUnit": "days",
                "countNumber": 30
            },
            "action": {
                "type": "expire"
            }
        }
    ]
}
EOF
}

# Allow other accounts access to the ECR Resource
resource "aws_ecr_repository_policy" "cross_account_access_policy" {
  repository = "${aws_ecr_repository.GridReboot.name}"

  policy = <<EOF
{
    "Version": "2008-10-17",
    "Statement": [
        {
            "Sid": "AllowPull",
            "Effect": "Allow",
            "Principal": {
                "AWS": ${jsonencode(var.allowed_roles)}
            },
            "Action": [
                "ecr:GetDownloadUrlForLayer",
                "ecr:BatchGetImage",
                "ecr:BatchCheckLayerAvailability"
            ]
        }
    ]
}
EOF
}
