variable "vpc_id" {} // VPC ID to run the ECS Task in
variable "subnets" {} // Subnet(s) to run the ECS Task in
variable "ecs_repository_url" {} // Repository URL that holds the grid reboot docker image
variable "grid_router_security_group_id" {} // the ID of the security group to allow connections to Grid Router

// Subscription URL on where to send alerts on reboot failures
variable "pagerduty_alert_subscription" {
  default = "https://events.pagerduty.com/integration/7aa341684a7c4111962d2eeaedf6a3ca/enqueue"
}

// The Grid Router hostname that the hubs are connected to
variable "grid_router_host" {
  default = "api-prod.browsergrid.xarth.tv"
}

variable "grid_hub_environment" { // the environment ec2 tag for the hub
  default = "prod"
}

variable "grid_node_environment" { // the environment ec2 tag for the nodes
  default = "prod"
}

// Cron Expression how often to run Grid Reboot
// Default: At 5am UTC (10pm PDT, 9pm PST) every 3 days
// https://docs.aws.amazon.com/lambda/latest/dg/tutorial-scheduled-events-schedule-expressions.html
variable "reboot_cron_expression" {
  default = "0 5 */3 * ? *"
}
