package helpers

// Takes a slice and returns a copy with all duplicates removed
func UniqueSlice(origSlice []string) []string {
	keys := make(map[string]bool)
	uniqueList := make([]string, 0)
	for _, v := range origSlice {
		if _, value := keys[v]; !value {
			keys[v] = true
			uniqueList = append(uniqueList, v)
		}
	}
	return uniqueList
}
