# Grid Router

Grid Router helps Seleinum Grid scale.
When a Selenium Client makes a request, the hub allocates a node for use. All additional requests are still routed through the hub to the node.
As more instances are added, the more traffic that has to travel through hub.

Grid Router aims to distribute sessions across multiple hubs.

## Architecture
[View on the wiki](https://wiki.twitch.com/display/QE/Architecture+Documentation)

### Diagram

#### New Session
![alt text](docs/images/V1_New_Session.png "New Session Diagram")
When a client makes a request for a node, Grid Router intercepts that request.
The request is passed to Hub. The Hub assigns a Session ID. The response is sent back to Grid Router.
Grid Router modifies the Session ID (explanation below). Grid Router returns the modified Session ID to the Client.

#### Existing Session
![alt text](docs/images/V1_Existing_Session.png "Existing Session Diagram")
Client makes a request to interact with that node. It passes the encoded session id that was returned from New Session.
Grid Router decodes that Session ID to the Hub's internal session id. It rewrites the URL to that Session ID and pases the request to the hub.

### Session ID Modification
There are two session ids.

Session ID 1 (Internal): Hub assigns a Session ID to know which node to redirect that request to.

Session ID 2 (External): Grid Router modifies the internal session id to append text.
Eventually this will be able to signify which Hub the request lives on. For existing sessions,
Grid Router can then decode that Session ID and pass it to the proper hub that holds the node.

## Running Server
With Docker (Builds & Run):
```./run.sh```

Without Docker, Locally:
```./run.sh -l```

### Configuration

Grid-Router currently supports these environment variables:

| ENV NAME | Description |
| -------- | ----------- |
| REDIS_HOST | The host to connect to Redis on (default, localhost) 
| REDIS_PORT | The port to connect to Redis on (default, 6379)
| LOG_LEVEL | The level to print logs to stdout for (default, info)

Eventually these will be supported via a Config Object. [QE-2273](https://jira.twitch.com/browse/QE-2273).

## Local Development
This is written in Go. Go was chosen for its speed - we want this to be as fast as possible considering
the amount of requests that may travel through it.

The source code can be found in [src](src).
The entry point of the application is within [src/main.go](src/main.go)

### Setting Up Your Environment
Running in Docker:
1) Install Docker (to run the container): https://docs.docker.com/install/

Running Locally:
1) Install Homebrew: https://brew.sh/
2) Install Go: http://brewformulas.org/Go
3) Set Up Your GoPath: https://github.com/golang/go/wiki/SettingGOPATH
4) Set up Golang: https://golang.github.io/dep/docs/installation.html
5) Install Redis. `brew install redis` and then launch it manually, `redis-server /usr/local/etc/redis.conf` or all the time, `brew services start redis`
6) Install Sandstorm CLI. https://wiki.twitch.com/display/SSE/Sandstorm+CLI 
7) Install Terraform v0.11. https://releases.hashicorp.com/terraform/

### Get The Source Code
```
go get code.justin.tv/qe/grid_router
```

### Building Application
Without Docker:
```
go build -o main src/main.go
./main
```

With Docker:
```./build.sh```

### Dependency Management
This project is set up to use Go Modules.

Run `go mod vendor` to install dependencies into the [vendor](src/vendor) folder.
We check the vendor folder into git, as our EC2 Instances don't have access to code.justin.tv to build the container.

### Tests
No Unit / Integration Tests are currently built for this.

However, E2E tests that measure the time difference are available with a readme in [test/timings](test/timings).

### Lint
```
go get -u golang.org/x/lint/golint
golint src/...
```

### Infrastructure
We use Terraform to spin up our infrastructure. See [terraform](terraform).

Instead of using `terraform apply`, use the `apply.sh` script.
This script fetches credentials from Sandstorm so that they can be passed to resources like Redis.

Example:
```
cd terraform
./apply.sh
```

Note:
`apply.sh` supports command line arguments, so you can do:
`apply.sh -target module.dev`
and it will convert to
`terraform apply -target module.dev`

## Logging
App & System logs are sent off host to Cloudwatch Logs. The log group is: `/aws/elasticbeanstalk/<ENVIRONMENT_NAME>/*`

Example:
`/aws/elasticbeanstalk/grid-router-prod/syslog`
