#!/bin/bash

# Determine if the user provided a -l argument, standing for local
run_local=false
for i in "$@" ; do
    if [[ $i == "-l" ]] ; then
        run_local=true
    fi
done

# Determine if should run locally or in docker
if [[ $run_local == true ]] ; then
    echo "Running Locally"
    echo "Ensure Redis is started: redis-server /usr/local/etc/redis.conf"
    (cd src && GR_LOCAL=true go run .)
else
    echo "Running in Docker"
    docker-compose up --force-recreate --build
fi
