#!/bin/bash

# This script will poll AWS Beanstalk for an application version. When it finds it, it will return 0
# Parameters:
#   GIT_COMMIT: The version label of the application version
#   EB_APP_NAME: The beanstalk application name to search

if [ -z "$GIT_COMMIT" ] || [ -z "$EB_APP_NAME" ]; then
  echo 'Must provide GIT_COMMIT and EB_APP_NAME variables'
  exit 1
fi

# Set initial length to 0
length=0

# Loop while length is less than 1
while [ "$length" -lt 1 ]
do
  # Grab the length of application versions
  length=$(aws elasticbeanstalk describe-application-versions \
    --application-name "$EB_APP_NAME" \
    --version-labels "$GIT_COMMIT" \
    --query "ApplicationVersions" | jq length)

    # If it's less than 1, print a warning and then retry
    if [ "$length" -lt 1 ]; then
      echo "App Version '$GIT_COMMIT' doesn't exist for '$EB_APP_NAME'. Trying again..."
      sleep 5
    fi
done

echo "Application version for '$GIT_COMMIT' is available for '$EB_APP_NAME'"
