package healthcheck

import (
	"fmt"
	"net/http"
)

// Simple page handler that will return back a 200 with a healthcheck message
// Important to have a specific page so that it doesn't require authentication
func Handler(w http.ResponseWriter, r *http.Request) {
	w.WriteHeader(http.StatusOK)
	fmt.Fprint(w, "I am alive!")
}
