package helpers

import (
	"github.com/stretchr/testify/assert"
	"testing"
)

func TestUniqueSlice(t *testing.T) {
	/*
		Modifies when there are duplicates
	*/
	orig := []string {
		"test1",
		"test2",
		"test2",
		"test3",
	}

	expected := []string {
		"test1",
		"test2",
		"test3",
	}

	assert.Equal(t, expected, UniqueSlice(orig))

	/*
		Does not modify when there are no duplicates
	*/
	orig = []string {
		"test1",
		"test2",
		"test3",
	}
	assert.Equal(t, orig, UniqueSlice(orig))
}
