// This package is a wrapper around CloudWatch Metrics that helps initialize the sessions,
// as well as get things like InstanceID for Dimensions
package instrumentor

import (
	"github.com/aws/aws-sdk-go/service/cloudwatch"
	"github.com/sirupsen/logrus"
)

type Instrumentor struct {
	MetricClient           MetricWriter
	AutoScalingGroupName   string
	Logger                 *logrus.Logger
	DryRun bool
}

type MetricWriter interface {
	PutMetricData(input *cloudwatch.PutMetricDataInput) (*cloudwatch.PutMetricDataOutput, error)
}

// Creates a new Instrumentor Object
func New(logger *logrus.Logger, metricClient MetricWriter, asgName string) *Instrumentor {
	instrum := &Instrumentor{
		MetricClient: metricClient,
		AutoScalingGroupName: asgName,
		Logger: logger,
	}
	return instrum
}

func (i *Instrumentor) PutMetricData(input *cloudwatch.PutMetricDataInput) (*cloudwatch.PutMetricDataOutput, error) {
	if i.DryRun {
		i.Logger.Debugf("[DryRun] Would instrument: %+v", input)
		return &cloudwatch.PutMetricDataOutput{}, nil
	} else {
		return i.MetricClient.PutMetricData(input)
	}
}
