package sdk

import (
	"fmt"
	"net/http"
	"time"
)

// Client for the Grid Router SDK
type Client struct {
	Scheme     string
	Host       string
	HttpClient *http.Client
}

// Return a new SDK Client to interact with Grid Router
// host Hostname for the Grid Router service to connect to. example: api.browsergrid.xarth.tv
func NewClient(host string) *Client {
	return &Client{
		Scheme: "https",
		Host: host,
		HttpClient: &http.Client{
			Timeout: time.Second * 10,
		},
	}
}

// Returns the Root URL, including Scheme and Host
func (c *Client) RootURL() string {
	return fmt.Sprintf("%s://%s", c.Scheme, c.Host)
}
