package sdk

import (
	"fmt"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	"testing"
)

func TestNewClient(t *testing.T) {
	t.Run("returns a proper client object", func (t *testing.T) {
		testHost := "my.test.host"

		c := NewClient(testHost)
		require.NotNil(t, c)
		assert.Equal(t, "https", c.Scheme)
		assert.Equal(t, testHost, c.Host)
		assert.NotNil(t, c.HttpClient)
	})
}

func TestClient_RootURL(t *testing.T) {
	t.Run("returns proper string", func (t *testing.T) {
		scheme := "https"
		host := "my.test.host"

		c := Client{
			Scheme: scheme,
			Host:   host,
		}

		expected := fmt.Sprintf("%s://%s", scheme, host) // https://my.test.host
		assert.Equal(t, expected, c.RootURL())
	})
}
