# Nice / Naiive
Naiive is a tool and a library for constructing quick-and-dirty regex based static analysis tests. Regexes always have their issues,
since they don't understand the syntax of the program they operate on.

Nice is a static analysis framework that naiive is built on, and eventually a static analysis tool with similar dynamics to naiive,
but higher confidence.

## Naiive Quickstart

```bash
go get -u code.justin.tv/tshadwell/nice/cmd/naiive
naiive scan net/http
naiive search -r 'Request' net/http # output is a lil ugly, still working on this one!
```

Ensure `$GOPATH/bin` is in your $PATH!

## Go Test Integration

This will automatically scan the current package and all its dependencies for issues:

```go
import "testing"
import "code.justin.tv/tshadwell/nice"
import "code.justin.tv/tshadwell/nice/naiive"

func TestNaiive(t *testing.T) {
	if testing.Short() {
		t.Skip("skipping static analysis in short mode")
	}

	nice.test(t, naiive.DefaultTests.ConfidenceRange(nice.MediumConfidence, nice.HighConfidence))
}
```

When you're happy, you should add the version you're using as a module dependency with `go mod tidy`. This will ensure your tests don't change underneath you when the library gets updated. Remember to run `go get -u` in your module to get the latest updates!



## Further Information
Check the godoc, or the locally hosted [doc.md](doc.md).
