
# Package nice
	Package nice implements a static analysis framework for Go.


```shell

	$ go get -u code.justin.tv/tshadwell/nice
```

## Contents
1. [Contents](#contents)
2. [Doc](#doc)
	1. [type Confidence](#Confidence)
		1. [func AllowedValues() []string](#Confidence.AllowedValues)
		2. [func MarshalText() (text []byte, err error)](#Confidence.MarshalText)
		3. [func String() string](#Confidence.String)
	2. [var DefaultProgram Program](#DefaultProgram)
	3. [type Describer](#Describer)
		1. [func TestConfidence() Confidence](#Describer.TestConfidence)
		2. [func TestDescription() string](#Describer.TestDescription)
		3. [func TestName() string](#Describer.TestName)
		4. [func TestSeverity() Severity](#Describer.TestSeverity)
	4. [type ErrAnonymousType](#ErrAnonymousType)
		1. [func reflect.Align() int](#ErrAnonymousType.reflect.Align)
		2. [func reflect.AssignableTo(reflect.u reflect.Type) bool](#ErrAnonymousType.reflect.AssignableTo)
		3. [func reflect.Bits() int](#ErrAnonymousType.reflect.Bits)
		4. [func reflect.ChanDir() reflect.ChanDir](#ErrAnonymousType.reflect.ChanDir)
		5. [func reflect.Comparable() bool](#ErrAnonymousType.reflect.Comparable)
		6. [func reflect.ConvertibleTo(reflect.u reflect.Type) bool](#ErrAnonymousType.reflect.ConvertibleTo)
		7. [func reflect.Elem() reflect.Type](#ErrAnonymousType.reflect.Elem)
		8. [func Error() string](#ErrAnonymousType.Error)
		9. [func reflect.Field(reflect.i int) reflect.StructField](#ErrAnonymousType.reflect.Field)
		10. [func reflect.FieldAlign() int](#ErrAnonymousType.reflect.FieldAlign)
		11. [func reflect.FieldByIndex(reflect.index []int) reflect.StructField](#ErrAnonymousType.reflect.FieldByIndex)
		12. [func reflect.FieldByName(reflect.name string) (reflect.StructField, bool)](#ErrAnonymousType.reflect.FieldByName)
		13. [func reflect.FieldByNameFunc(reflect.match string bool) (reflect.StructField, bool)](#ErrAnonymousType.reflect.FieldByNameFunc)
		14. [func reflect.Implements(reflect.u reflect.Type) bool](#ErrAnonymousType.reflect.Implements)
		15. [func reflect.In(reflect.i int) reflect.Type](#ErrAnonymousType.reflect.In)
		16. [func reflect.IsVariadic() bool](#ErrAnonymousType.reflect.IsVariadic)
		17. [func reflect.Key() reflect.Type](#ErrAnonymousType.reflect.Key)
		18. [func reflect.Kind() reflect.Kind](#ErrAnonymousType.reflect.Kind)
		19. [func reflect.Len() int](#ErrAnonymousType.reflect.Len)
		20. [func reflect.Methodint reflect.Method](#ErrAnonymousType.reflect.Method)
		21. [func reflect.MethodByNamestring (reflect.Method, bool)](#ErrAnonymousType.reflect.MethodByName)
		22. [func reflect.Name() string](#ErrAnonymousType.reflect.Name)
		23. [func reflect.NumField() int](#ErrAnonymousType.reflect.NumField)
		24. [func reflect.NumIn() int](#ErrAnonymousType.reflect.NumIn)
		25. [func reflect.NumMethod() int](#ErrAnonymousType.reflect.NumMethod)
		26. [func reflect.NumOut() int](#ErrAnonymousType.reflect.NumOut)
		27. [func reflect.Out(reflect.i int) reflect.Type](#ErrAnonymousType.reflect.Out)
		28. [func reflect.PkgPath() string](#ErrAnonymousType.reflect.PkgPath)
		29. [func reflect.Size() uintptr](#ErrAnonymousType.reflect.Size)
		30. [func reflect.String() string](#ErrAnonymousType.reflect.String)
	5. [type ErrLocatingValue](#ErrLocatingValue)
		1. [func reflect.Align() int](#ErrLocatingValue.reflect.Align)
		2. [func reflect.AssignableTo(reflect.u reflect.Type) bool](#ErrLocatingValue.reflect.AssignableTo)
		3. [func reflect.Bits() int](#ErrLocatingValue.reflect.Bits)
		4. [func reflect.ChanDir() reflect.ChanDir](#ErrLocatingValue.reflect.ChanDir)
		5. [func reflect.Comparable() bool](#ErrLocatingValue.reflect.Comparable)
		6. [func reflect.ConvertibleTo(reflect.u reflect.Type) bool](#ErrLocatingValue.reflect.ConvertibleTo)
		7. [func reflect.Elem() reflect.Type](#ErrLocatingValue.reflect.Elem)
		8. [func Error() string](#ErrLocatingValue.Error)
		9. [func reflect.Field(reflect.i int) reflect.StructField](#ErrLocatingValue.reflect.Field)
		10. [func reflect.FieldAlign() int](#ErrLocatingValue.reflect.FieldAlign)
		11. [func reflect.FieldByIndex(reflect.index []int) reflect.StructField](#ErrLocatingValue.reflect.FieldByIndex)
		12. [func reflect.FieldByName(reflect.name string) (reflect.StructField, bool)](#ErrLocatingValue.reflect.FieldByName)
		13. [func reflect.FieldByNameFunc(reflect.match string bool) (reflect.StructField, bool)](#ErrLocatingValue.reflect.FieldByNameFunc)
		14. [func reflect.Implements(reflect.u reflect.Type) bool](#ErrLocatingValue.reflect.Implements)
		15. [func reflect.In(reflect.i int) reflect.Type](#ErrLocatingValue.reflect.In)
		16. [func reflect.IsVariadic() bool](#ErrLocatingValue.reflect.IsVariadic)
		17. [func reflect.Key() reflect.Type](#ErrLocatingValue.reflect.Key)
		18. [func reflect.Kind() reflect.Kind](#ErrLocatingValue.reflect.Kind)
		19. [func reflect.Len() int](#ErrLocatingValue.reflect.Len)
		20. [func reflect.Methodint reflect.Method](#ErrLocatingValue.reflect.Method)
		21. [func reflect.MethodByNamestring (reflect.Method, bool)](#ErrLocatingValue.reflect.MethodByName)
		22. [func reflect.Name() string](#ErrLocatingValue.reflect.Name)
		23. [func reflect.NumField() int](#ErrLocatingValue.reflect.NumField)
		24. [func reflect.NumIn() int](#ErrLocatingValue.reflect.NumIn)
		25. [func reflect.NumMethod() int](#ErrLocatingValue.reflect.NumMethod)
		26. [func reflect.NumOut() int](#ErrLocatingValue.reflect.NumOut)
		27. [func reflect.Out(reflect.i int) reflect.Type](#ErrLocatingValue.reflect.Out)
		28. [func reflect.PkgPath() string](#ErrLocatingValue.reflect.PkgPath)
		29. [func reflect.Size() uintptr](#ErrLocatingValue.reflect.Size)
		30. [func reflect.String() string](#ErrLocatingValue.reflect.String)
	6. [type Errors](#Errors)
		1. [func Error() string](#Errors.Error)
		2. [func String() string](#Errors.String)
	7. [type ExecError](#ExecError)
		1. [func Error() string](#ExecError.Error)
		2. [func os.Exited() bool](#ExecError.os.Exited)
		3. [func os.Pid() int](#ExecError.os.Pid)
		4. [func String() string](#ExecError.String)
		5. [func os.Success() bool](#ExecError.os.Success)
		6. [func os.Sys() interface{}](#ExecError.os.Sys)
		7. [func os.SysUsage() interface{}](#ExecError.os.SysUsage)
		8. [func os.SystemTime() time.Duration](#ExecError.os.SystemTime)
		9. [func os.UserTime() time.Duration](#ExecError.os.UserTime)
	8. [type Finding](#Finding)
		1. [func Interesting() (partial string, err error)](#Finding.Interesting)
		2. [func String() string](#Finding.String)
		3. [func TestConfidence() Confidence](#Finding.TestConfidence)
		4. [func TestDescription() string](#Finding.TestDescription)
		5. [func TestName() string](#Finding.TestName)
		6. [func TestSeverity() Severity](#Finding.TestSeverity)
	9. [var FindingTemplate *template.Template](#FindingTemplate)
	10. [type Findings](#Findings)
		1. [func Format(longDescription bool) (text []byte, err error)](#Findings.Format)
		2. [func Len() int](#Findings.Len)
		3. [func Less(i int, j int) bool](#Findings.Less)
		4. [func MarshalText() (text []byte, err error)](#Findings.MarshalText)
		5. [func Sort() (results []struct {  Describer  Findings })](#Findings.Sort)
		6. [func Swap(i int, j int)](#Findings.Swap)
	11. [func FromString(pkgText string) (m TmpPkg, err error)](#FromString)
	12. [const HighConfidence = 3](#HighConfidence)
	13. [const HighSeverity = 3](#HighSeverity)
	14. [type ImportError](#ImportError)
		1. [func Error() string](#ImportError.Error)
	15. [const LowConfidence = 1](#LowConfidence)
	16. [const LowSeverity = 1](#LowSeverity)
	17. [const MediumConfidence = 2](#MediumConfidence)
	18. [const MediumSeverity = 2](#MediumSeverity)
	19. [func MustPosition(possiblePosition token.Position, err error) (position token.Position)](#MustPosition)
	20. [type Package](#Package)
		1. [func types.ObjectOf(types.id *ast.Ident) types.Object](#Package.types.ObjectOf)
		2. [[func]() loader.String() string](#Package.loader.String)
		3. [func types.TypeOf(types.e ast.Expr) types.Type](#Package.types.TypeOf)
	21. [type Program](#Program)
	22. [type Report](#Report)
	23. [type Severity](#Severity)
		1. [func AllowedValues() []string](#Severity.AllowedValues)
		2. [func MarshalText() (text []byte, err error)](#Severity.MarshalText)
		3. [func String() string](#Severity.String)
	24. [type Ssa](#Ssa)
		1. [[func]() ssa.AllPackages() []*ssa.Package](#Ssa.ssa.AllPackages)
		2. [[func]() ssa.Build()](#Ssa.ssa.Build)
		3. [func Callgraph(root *ssa.Function) (result *rta.Result, err error)](#Ssa.Callgraph)
		4. [[func]() ssa.ConstValue(ssa.obj *types.Const) *ssa.Const](#Ssa.ssa.ConstValue)
		5. [[func]() ssa.CreatePackage(ssa.pkg *types.Package, ssa.files []*ast.File, ssa.info *types.Info, ssa.importable bool) *ssa.Package](#Ssa.ssa.CreatePackage)
		6. [[func]() ssa.CreateTestMainPackage(ssa.pkg *ssa.Package) *ssa.Package](#Ssa.ssa.CreateTestMainPackage)
		7. [[func]() ssa.FuncValue(ssa.obj *types.Func) *ssa.Function](#Ssa.ssa.FuncValue)
		8. [func Functions() (fns map[*ssa.Function] bool, err error)](#Ssa.Functions)
		9. [[func]() ssa.ImportedPackage(ssa.path string) *ssa.Package](#Ssa.ssa.ImportedPackage)
		10. [func LocateType(value interface{}) (typ *ssa.Type, err error)](#Ssa.LocateType)
		11. [[func]() ssa.LookupMethod(ssa.T types.Type, ssa.pkg *types.Package, ssa.name string) *ssa.Function](#Ssa.ssa.LookupMethod)
		12. [[func]() ssa.MethodValue(ssa.sel *types.Selection) *ssa.Function](#Ssa.ssa.MethodValue)
		13. [[func]() ssa.NewFunction(ssa.name string, ssa.sig *types.Signature, ssa.provenance string) *ssa.Function](#Ssa.ssa.NewFunction)
		14. [func NodePos(n ssa.Node) (pos token.Pos, err error)](#Ssa.NodePos)
		15. [func NodePosition(n ssa.Node) (position token.Position, err error)](#Ssa.NodePosition)
		16. [[func]() ssa.Package(ssa.obj *types.Package) *ssa.Package](#Ssa.ssa.Package)
		17. [func Position(pos token.Pos) (position token.Position, err error)](#Ssa.Position)
		18. [[func]() ssa.RuntimeTypes() []types.Type](#Ssa.ssa.RuntimeTypes)
		19. [func ValuePos(v ssa.Value) (pos token.Pos, err error)](#Ssa.ValuePos)
		20. [func ValuePosition(v ssa.Value) (position token.Position, err error)](#Ssa.ValuePosition)
		21. [[func]() ssa.VarValue(ssa.obj *types.Var, ssa.pkg *ssa.Package, ssa.ref []ast.Node) (ssa.value ssa.Value, ssa.isAddr bool)](#Ssa.ssa.VarValue)
	25. [func Test(t *testing.T, nice Tester, pkgs []string)](#Test)
	26. [var TestBulldozingError testBulldozingError](#TestBulldozingError)
	27. [type Tester](#Tester)
		1. [func NiceTest(p *Program) (Findings, error)](#Tester.NiceTest)
	28. [type TesterFunc](#TesterFunc)
		1. [func NiceTest(p *Program) (Findings, error)](#TesterFunc.NiceTest)
	29. [type TmpPkg](#TmpPkg)
		1. [func Ast() (program *loader.Program, err error)](#TmpPkg.Ast)
		2. [func BuildContext() (ctx *build.Context, err error)](#TmpPkg.BuildContext)
		3. [func CleanPath(path string) (s string, err error)](#TmpPkg.CleanPath)
		4. [func Close() error](#TmpPkg.Close)
		5. [func Config() (config *loader.Config, err error)](#TmpPkg.Config)
		6. [func DumpSsa() (ssaDigest []byte, err error)](#TmpPkg.DumpSsa)
		7. [func Get(args []string, paths []string) (err error)](#TmpPkg.Get)
		8. [func Import(paths []string) (err error)](#TmpPkg.Import)
		9. [func LoadSsa() (err error)](#TmpPkg.LoadSsa)
		10. [func MustCleanPath(path string) (s string)](#TmpPkg.MustCleanPath)
		11. [func PkgSsa() (pkg *ssa.Package, err error)](#TmpPkg.PkgSsa)
		12. [func TargetPackages() (initials []Package, err error)](#TmpPkg.TargetPackages)
		13. [func Test(t *testing.T, nice Tester)](#TmpPkg.Test)
3. [Imports](#imports)


## Doc


### <a name="Confidence"></a>  [type](constants.go#L5) [Confidence](#Confidence)
#### <a name="Confidence.AllowedValues"></a> [func](constants.go#L23) **AllowedValues**() [][string](//godoc.org/builtin#string)
#### <a name="Confidence.MarshalText"></a> [func](constants.go#L24) **MarshalText**() (text [][byte](//godoc.org/builtin#byte), err [error](//godoc.org/builtin#error))
#### <a name="Confidence.String"></a> [func](constants.go#L22) **String**() [string](//godoc.org/builtin#string)
> [int](//godoc.org/builtin#int)




### <a name="DefaultProgram"></a>  [var](nice.go#L381) [DefaultProgram](#DefaultProgram) [Program](#Program)
> struct {  Targets [][string](//godoc.org/builtin#string)  Ssa \*[Ssa](#Ssa)  Tracker \*[progress.Tracker](//godoc.org/code.justin.tv/tshadwell/nice/progress#Tracker) }




### <a name="Describer"></a>  [type](nice.go#L340) [Describer](#Describer)
#### <a name="Describer.TestConfidence"></a> [func](nice.go#L343) **TestConfidence**() [Confidence](#Confidence)
#### <a name="Describer.TestDescription"></a> [func](nice.go#L342) **TestDescription**() [string](//godoc.org/builtin#string)
#### <a name="Describer.TestName"></a> [func](nice.go#L341) **TestName**() [string](//godoc.org/builtin#string)
#### <a name="Describer.TestSeverity"></a> [func](nice.go#L344) **TestSeverity**() [Severity](#Severity)
> interface{
>   **TestConfidence**() [Confidence](#Confidence) ; **TestDescription**() [string](//godoc.org/builtin#string) ; **TestName**() [string](//godoc.org/builtin#string) ; **TestSeverity**() [Severity](#Severity)
> }


Describer is an interface type describing what this finding means


### <a name="ErrAnonymousType"></a>  [type](nice.go#L560) [ErrAnonymousType](#ErrAnonymousType)
#### <a name="ErrAnonymousType.reflect.Align"></a> [func](//golang.org/src/reflect/type.go#L43) **reflect.Align**() [int](//godoc.org/builtin#int)
#### <a name="ErrAnonymousType.reflect.AssignableTo"></a> [func](//golang.org/src/reflect/type.go#L101) **reflect.AssignableTo**(reflect.u [reflect.Type](//godoc.org/reflect#Type)) [bool](//godoc.org/builtin#bool)
#### <a name="ErrAnonymousType.reflect.Bits"></a> [func](//golang.org/src/reflect/type.go#L124) **reflect.Bits**() [int](//godoc.org/builtin#int)
#### <a name="ErrAnonymousType.reflect.ChanDir"></a> [func](//golang.org/src/reflect/type.go#L128) **reflect.ChanDir**() [reflect.ChanDir](//godoc.org/reflect#ChanDir)
#### <a name="ErrAnonymousType.reflect.Comparable"></a> [func](//golang.org/src/reflect/type.go#L107) **reflect.Comparable**() [bool](//godoc.org/builtin#bool)
#### <a name="ErrAnonymousType.reflect.ConvertibleTo"></a> [func](//golang.org/src/reflect/type.go#L104) **reflect.ConvertibleTo**(reflect.u [reflect.Type](//godoc.org/reflect#Type)) [bool](//godoc.org/builtin#bool)
#### <a name="ErrAnonymousType.reflect.Elem"></a> [func](//golang.org/src/reflect/type.go#L146) **reflect.Elem**() [reflect.Type](//godoc.org/reflect#Type)
#### <a name="ErrAnonymousType.Error"></a> [func](nice.go#L562) **Error**() [string](//godoc.org/builtin#string)
#### <a name="ErrAnonymousType.reflect.Field"></a> [func](//golang.org/src/reflect/type.go#L151) **reflect.Field**(reflect.i [int](//godoc.org/builtin#int)) [reflect.StructField](//godoc.org/reflect#StructField)
#### <a name="ErrAnonymousType.reflect.FieldAlign"></a> [func](//golang.org/src/reflect/type.go#L47) **reflect.FieldAlign**() [int](//godoc.org/builtin#int)
#### <a name="ErrAnonymousType.reflect.FieldByIndex"></a> [func](//golang.org/src/reflect/type.go#L157) **reflect.FieldByIndex**(reflect.index [][int](//godoc.org/builtin#int)) [reflect.StructField](//godoc.org/reflect#StructField)
#### <a name="ErrAnonymousType.reflect.FieldByName"></a> [func](//golang.org/src/reflect/type.go#L161) **reflect.FieldByName**(reflect.name [string](//godoc.org/builtin#string)) ([reflect.StructField](//godoc.org/reflect#StructField), [bool](//godoc.org/builtin#bool))
#### <a name="ErrAnonymousType.reflect.FieldByNameFunc"></a> [func](//golang.org/src/reflect/type.go#L175) **reflect.FieldByNameFunc**(reflect.match [string](//godoc.org/builtin#string) [bool](//godoc.org/builtin#bool)) ([reflect.StructField](//godoc.org/reflect#StructField), [bool](//godoc.org/builtin#bool))
#### <a name="ErrAnonymousType.reflect.Implements"></a> [func](//golang.org/src/reflect/type.go#L98) **reflect.Implements**(reflect.u [reflect.Type](//godoc.org/reflect#Type)) [bool](//godoc.org/builtin#bool)
#### <a name="ErrAnonymousType.reflect.In"></a> [func](//golang.org/src/reflect/type.go#L180) **reflect.In**(reflect.i [int](//godoc.org/builtin#int)) [reflect.Type](//godoc.org/reflect#Type)
#### <a name="ErrAnonymousType.reflect.IsVariadic"></a> [func](//golang.org/src/reflect/type.go#L142) **reflect.IsVariadic**() [bool](//godoc.org/builtin#bool)
#### <a name="ErrAnonymousType.reflect.Key"></a> [func](//golang.org/src/reflect/type.go#L184) **reflect.Key**() [reflect.Type](//godoc.org/reflect#Type)
#### <a name="ErrAnonymousType.reflect.Kind"></a> [func](//golang.org/src/reflect/type.go#L95) **reflect.Kind**() [reflect.Kind](//godoc.org/reflect#Kind)
#### <a name="ErrAnonymousType.reflect.Len"></a> [func](//golang.org/src/reflect/type.go#L188) **reflect.Len**() [int](//godoc.org/builtin#int)
#### <a name="ErrAnonymousType.reflect.Method"></a> [func](//golang.org/src/reflect/type.go#L57) **reflect.Method**[int](//godoc.org/builtin#int) [reflect.Method](//godoc.org/reflect#Method)
#### <a name="ErrAnonymousType.reflect.MethodByName"></a> [func](//golang.org/src/reflect/type.go#L67) **reflect.MethodByName**[string](//godoc.org/builtin#string) ([reflect.Method](//godoc.org/reflect#Method), [bool](//godoc.org/builtin#bool))
#### <a name="ErrAnonymousType.reflect.Name"></a> [func](//golang.org/src/reflect/type.go#L74) **reflect.Name**() [string](//godoc.org/builtin#string)
#### <a name="ErrAnonymousType.reflect.NumField"></a> [func](//golang.org/src/reflect/type.go#L192) **reflect.NumField**() [int](//godoc.org/builtin#int)
#### <a name="ErrAnonymousType.reflect.NumIn"></a> [func](//golang.org/src/reflect/type.go#L196) **reflect.NumIn**() [int](//godoc.org/builtin#int)
#### <a name="ErrAnonymousType.reflect.NumMethod"></a> [func](//golang.org/src/reflect/type.go#L70) **reflect.NumMethod**() [int](//godoc.org/builtin#int)
#### <a name="ErrAnonymousType.reflect.NumOut"></a> [func](//golang.org/src/reflect/type.go#L200) **reflect.NumOut**() [int](//godoc.org/builtin#int)
#### <a name="ErrAnonymousType.reflect.Out"></a> [func](//golang.org/src/reflect/type.go#L205) **reflect.Out**(reflect.i [int](//godoc.org/builtin#int)) [reflect.Type](//godoc.org/reflect#Type)
#### <a name="ErrAnonymousType.reflect.PkgPath"></a> [func](//golang.org/src/reflect/type.go#L81) **reflect.PkgPath**() [string](//godoc.org/builtin#string)
#### <a name="ErrAnonymousType.reflect.Size"></a> [func](//golang.org/src/reflect/type.go#L85) **reflect.Size**() [uintptr](//godoc.org/builtin#uintptr)
#### <a name="ErrAnonymousType.reflect.String"></a> [func](//golang.org/src/reflect/type.go#L92) **reflect.String**() [string](//godoc.org/builtin#string)
> struct {  [reflect.Type](//godoc.org/reflect#Type) }




### <a name="ErrLocatingValue"></a>  [type](nice.go#L566) [ErrLocatingValue](#ErrLocatingValue)
#### <a name="ErrLocatingValue.reflect.Align"></a> [func](//golang.org/src/reflect/type.go#L43) **reflect.Align**() [int](//godoc.org/builtin#int)
#### <a name="ErrLocatingValue.reflect.AssignableTo"></a> [func](//golang.org/src/reflect/type.go#L101) **reflect.AssignableTo**(reflect.u [reflect.Type](//godoc.org/reflect#Type)) [bool](//godoc.org/builtin#bool)
#### <a name="ErrLocatingValue.reflect.Bits"></a> [func](//golang.org/src/reflect/type.go#L124) **reflect.Bits**() [int](//godoc.org/builtin#int)
#### <a name="ErrLocatingValue.reflect.ChanDir"></a> [func](//golang.org/src/reflect/type.go#L128) **reflect.ChanDir**() [reflect.ChanDir](//godoc.org/reflect#ChanDir)
#### <a name="ErrLocatingValue.reflect.Comparable"></a> [func](//golang.org/src/reflect/type.go#L107) **reflect.Comparable**() [bool](//godoc.org/builtin#bool)
#### <a name="ErrLocatingValue.reflect.ConvertibleTo"></a> [func](//golang.org/src/reflect/type.go#L104) **reflect.ConvertibleTo**(reflect.u [reflect.Type](//godoc.org/reflect#Type)) [bool](//godoc.org/builtin#bool)
#### <a name="ErrLocatingValue.reflect.Elem"></a> [func](//golang.org/src/reflect/type.go#L146) **reflect.Elem**() [reflect.Type](//godoc.org/reflect#Type)
#### <a name="ErrLocatingValue.Error"></a> [func](nice.go#L568) **Error**() [string](//godoc.org/builtin#string)
#### <a name="ErrLocatingValue.reflect.Field"></a> [func](//golang.org/src/reflect/type.go#L151) **reflect.Field**(reflect.i [int](//godoc.org/builtin#int)) [reflect.StructField](//godoc.org/reflect#StructField)
#### <a name="ErrLocatingValue.reflect.FieldAlign"></a> [func](//golang.org/src/reflect/type.go#L47) **reflect.FieldAlign**() [int](//godoc.org/builtin#int)
#### <a name="ErrLocatingValue.reflect.FieldByIndex"></a> [func](//golang.org/src/reflect/type.go#L157) **reflect.FieldByIndex**(reflect.index [][int](//godoc.org/builtin#int)) [reflect.StructField](//godoc.org/reflect#StructField)
#### <a name="ErrLocatingValue.reflect.FieldByName"></a> [func](//golang.org/src/reflect/type.go#L161) **reflect.FieldByName**(reflect.name [string](//godoc.org/builtin#string)) ([reflect.StructField](//godoc.org/reflect#StructField), [bool](//godoc.org/builtin#bool))
#### <a name="ErrLocatingValue.reflect.FieldByNameFunc"></a> [func](//golang.org/src/reflect/type.go#L175) **reflect.FieldByNameFunc**(reflect.match [string](//godoc.org/builtin#string) [bool](//godoc.org/builtin#bool)) ([reflect.StructField](//godoc.org/reflect#StructField), [bool](//godoc.org/builtin#bool))
#### <a name="ErrLocatingValue.reflect.Implements"></a> [func](//golang.org/src/reflect/type.go#L98) **reflect.Implements**(reflect.u [reflect.Type](//godoc.org/reflect#Type)) [bool](//godoc.org/builtin#bool)
#### <a name="ErrLocatingValue.reflect.In"></a> [func](//golang.org/src/reflect/type.go#L180) **reflect.In**(reflect.i [int](//godoc.org/builtin#int)) [reflect.Type](//godoc.org/reflect#Type)
#### <a name="ErrLocatingValue.reflect.IsVariadic"></a> [func](//golang.org/src/reflect/type.go#L142) **reflect.IsVariadic**() [bool](//godoc.org/builtin#bool)
#### <a name="ErrLocatingValue.reflect.Key"></a> [func](//golang.org/src/reflect/type.go#L184) **reflect.Key**() [reflect.Type](//godoc.org/reflect#Type)
#### <a name="ErrLocatingValue.reflect.Kind"></a> [func](//golang.org/src/reflect/type.go#L95) **reflect.Kind**() [reflect.Kind](//godoc.org/reflect#Kind)
#### <a name="ErrLocatingValue.reflect.Len"></a> [func](//golang.org/src/reflect/type.go#L188) **reflect.Len**() [int](//godoc.org/builtin#int)
#### <a name="ErrLocatingValue.reflect.Method"></a> [func](//golang.org/src/reflect/type.go#L57) **reflect.Method**[int](//godoc.org/builtin#int) [reflect.Method](//godoc.org/reflect#Method)
#### <a name="ErrLocatingValue.reflect.MethodByName"></a> [func](//golang.org/src/reflect/type.go#L67) **reflect.MethodByName**[string](//godoc.org/builtin#string) ([reflect.Method](//godoc.org/reflect#Method), [bool](//godoc.org/builtin#bool))
#### <a name="ErrLocatingValue.reflect.Name"></a> [func](//golang.org/src/reflect/type.go#L74) **reflect.Name**() [string](//godoc.org/builtin#string)
#### <a name="ErrLocatingValue.reflect.NumField"></a> [func](//golang.org/src/reflect/type.go#L192) **reflect.NumField**() [int](//godoc.org/builtin#int)
#### <a name="ErrLocatingValue.reflect.NumIn"></a> [func](//golang.org/src/reflect/type.go#L196) **reflect.NumIn**() [int](//godoc.org/builtin#int)
#### <a name="ErrLocatingValue.reflect.NumMethod"></a> [func](//golang.org/src/reflect/type.go#L70) **reflect.NumMethod**() [int](//godoc.org/builtin#int)
#### <a name="ErrLocatingValue.reflect.NumOut"></a> [func](//golang.org/src/reflect/type.go#L200) **reflect.NumOut**() [int](//godoc.org/builtin#int)
#### <a name="ErrLocatingValue.reflect.Out"></a> [func](//golang.org/src/reflect/type.go#L205) **reflect.Out**(reflect.i [int](//godoc.org/builtin#int)) [reflect.Type](//godoc.org/reflect#Type)
#### <a name="ErrLocatingValue.reflect.PkgPath"></a> [func](//golang.org/src/reflect/type.go#L81) **reflect.PkgPath**() [string](//godoc.org/builtin#string)
#### <a name="ErrLocatingValue.reflect.Size"></a> [func](//golang.org/src/reflect/type.go#L85) **reflect.Size**() [uintptr](//godoc.org/builtin#uintptr)
#### <a name="ErrLocatingValue.reflect.String"></a> [func](//golang.org/src/reflect/type.go#L92) **reflect.String**() [string](//godoc.org/builtin#string)
> struct {  [reflect.Type](//godoc.org/reflect#Type) }




### <a name="Errors"></a>  [type](nice.go#L411) [Errors](#Errors)
#### <a name="Errors.Error"></a> [func](nice.go#L421) **Error**() [string](//godoc.org/builtin#string)
#### <a name="Errors.String"></a> [func](nice.go#L425) **String**() [string](//godoc.org/builtin#string)
> [][error](//godoc.org/builtin#error)




### <a name="ExecError"></a>  [type](nice.go#L572) [ExecError](#ExecError)
#### <a name="ExecError.Error"></a> [func](nice.go#L579) **Error**() [string](//godoc.org/builtin#string)
#### <a name="ExecError.os.Exited"></a> [func](//golang.org/src/os/exec.go#L145) **os.Exited**() [bool](//godoc.org/builtin#bool)
#### <a name="ExecError.os.Pid"></a> [func](//golang.org/src/os/exec_posix.go#L65) **os.Pid**() [int](//godoc.org/builtin#int)
#### <a name="ExecError.String"></a> [func](nice.go#L583) **String**() [string](//godoc.org/builtin#string)
#### <a name="ExecError.os.Success"></a> [func](//golang.org/src/os/exec.go#L151) **os.Success**() [bool](//godoc.org/builtin#bool)
#### <a name="ExecError.os.Sys"></a> [func](//golang.org/src/os/exec.go#L158) **os.Sys**() interface{}
#### <a name="ExecError.os.SysUsage"></a> [func](//golang.org/src/os/exec.go#L167) **os.SysUsage**() interface{}
#### <a name="ExecError.os.SystemTime"></a> [func](//golang.org/src/os/exec.go#L140) **os.SystemTime**() [time.Duration](//godoc.org/time#Duration)
#### <a name="ExecError.os.UserTime"></a> [func](//golang.org/src/os/exec.go#L135) **os.UserTime**() [time.Duration](//godoc.org/time#Duration)
> struct {  \*[exec.ExitError](//godoc.org/os/exec#ExitError)  Stdout [bytes.Buffer](//godoc.org/bytes#Buffer)  Cmd \*[exec.Cmd](//godoc.org/os/exec#Cmd) }




### <a name="Finding"></a>  [type](nice.go#L347) [Finding](#Finding)
#### <a name="Finding.Interesting"></a> [func](nice.go#L355) **Interesting**() (partial [string](//godoc.org/builtin#string), err [error](//godoc.org/builtin#error))
Interesting returns whatever is between the two Positions in this Finding,
and the remainder of the line.

#### <a name="Finding.String"></a> [func](nice.go#L375) **String**() [string](//godoc.org/builtin#string)
#### <a name="Finding.TestConfidence"></a> [func](nice.go#L343) **TestConfidence**() [Confidence](#Confidence)
#### <a name="Finding.TestDescription"></a> [func](nice.go#L342) **TestDescription**() [string](//godoc.org/builtin#string)
#### <a name="Finding.TestName"></a> [func](nice.go#L341) **TestName**() [string](//godoc.org/builtin#string)
#### <a name="Finding.TestSeverity"></a> [func](nice.go#L344) **TestSeverity**() [Severity](#Severity)
> struct {  Position [2][token.Position](//godoc.org/go/token#Position)  [Describer](#Describer) }




### <a name="FindingTemplate"></a>  [var](nice.go#L156) [FindingTemplate](#FindingTemplate) \*[template.Template](//godoc.org/text/template#Template)



### <a name="Findings"></a>  [type](nice.go#L136) [Findings](#Findings)
#### <a name="Findings.Format"></a> [func](nice.go#L201) **Format**(longDescription [bool](//godoc.org/builtin#bool)) (text [][byte](//godoc.org/builtin#byte), err [error](//godoc.org/builtin#error))
#### <a name="Findings.Len"></a> [func](nice.go#L140) **Len**() [int](//godoc.org/builtin#int)
#### <a name="Findings.Less"></a> [func](nice.go#L141) **Less**(i [int](//godoc.org/builtin#int), j [int](//godoc.org/builtin#int)) [bool](//godoc.org/builtin#bool)
#### <a name="Findings.MarshalText"></a> [func](nice.go#L194) **MarshalText**() (text [][byte](//godoc.org/builtin#byte), err [error](//godoc.org/builtin#error))
#### <a name="Findings.Sort"></a> [func](nice.go#L307) **Sort**() (results []struct {  [Describer](#Describer)  [Findings](#Findings) })
Sort batches the Findings into the test they come from (by interface target)
then sorts the Findings in position string order, and the batches of Findings in
order of test serverity

#### <a name="Findings.Swap"></a> [func](nice.go#L142) **Swap**(i [int](//godoc.org/builtin#int), j [int](//godoc.org/builtin#int))
> [][Finding](#Finding)




### <a name="FromString"></a>  [func](tests.go#L51) **[FromString](#FromString)**(pkgText [string](//godoc.org/builtin#string)) (m [TmpPkg](#TmpPkg), err [error](//godoc.org/builtin#error))



### <a name="HighConfidence"></a>  [const](constants.go#L11) [HighConfidence](#HighConfidence) = 3
> [int](//godoc.org/builtin#int)




### <a name="HighSeverity"></a>  [const](constants.go#L43) [HighSeverity](#HighSeverity) = 3
> [int](//godoc.org/builtin#int)




### <a name="ImportError"></a>  [type](nice.go#L612) [ImportError](#ImportError)
#### <a name="ImportError.Error"></a> [func](nice.go#L614) **Error**() [string](//godoc.org/builtin#string)
> [][string](//godoc.org/builtin#string)




### <a name="LowConfidence"></a>  [const](constants.go#L9) [LowConfidence](#LowConfidence) = 1
> [int](//godoc.org/builtin#int)




### <a name="LowSeverity"></a>  [const](constants.go#L41) [LowSeverity](#LowSeverity) = 1
> [int](//godoc.org/builtin#int)




### <a name="MediumConfidence"></a>  [const](constants.go#L10) [MediumConfidence](#MediumConfidence) = 2
> [int](//godoc.org/builtin#int)




### <a name="MediumSeverity"></a>  [const](constants.go#L42) [MediumSeverity](#MediumSeverity) = 2
> [int](//godoc.org/builtin#int)




### <a name="MustPosition"></a>  [func](nice.go#L117) **[MustPosition](#MustPosition)**(possiblePosition [token.Position](//godoc.org/go/token#Position), err [error](//godoc.org/builtin#error)) (position [token.Position](//godoc.org/go/token#Position))



### <a name="Package"></a>  [type](nice.go#L228) [Package](#Package)
#### <a name="Package.types.ObjectOf"></a> [func](//golang.org/src/go/types/api.go#L247) **types.ObjectOf**(types.id \*[ast.Ident](//godoc.org/go/ast#Ident)) [types.Object](//godoc.org/go/types#Object)
#### <a name="Package.loader.String"></a> [func]() **loader.String**() [string](//godoc.org/builtin#string)
#### <a name="Package.types.TypeOf"></a> [func](//golang.org/src/go/types/api.go#L227) **types.TypeOf**(types.e [ast.Expr](//godoc.org/go/ast#Expr)) [types.Type](//godoc.org/go/types#Type)
> struct {  \*[loader.PackageInfo](//godoc.org/golang.org/x/tools/go/loader#PackageInfo) }


Package is a convenience wrapper of *loader.PackageInfo


### <a name="Program"></a>  [type](nice.go#L35) [Program](#Program)
> struct {  Targets [][string](//godoc.org/builtin#string)  Ssa \*[Ssa](#Ssa)  Tracker \*[progress.Tracker](//godoc.org/code.justin.tv/tshadwell/nice/progress#Tracker) }


Program lazily collects static information on a Go program.
a new Progam is a ready to use Program; nice will automatically
load the Program in the current directory (which is the package being
tested by go test).


### <a name="Report"></a>  [type](nice.go#L198) [Report](#Report)
> struct {}




### <a name="Severity"></a>  [type](constants.go#L37) [Severity](#Severity)
#### <a name="Severity.AllowedValues"></a> [func](constants.go#L55) **AllowedValues**() [][string](//godoc.org/builtin#string)
#### <a name="Severity.MarshalText"></a> [func](constants.go#L56) **MarshalText**() (text [][byte](//godoc.org/builtin#byte), err [error](//godoc.org/builtin#error))
#### <a name="Severity.String"></a> [func](constants.go#L54) **String**() [string](//godoc.org/builtin#string)
> [int](//godoc.org/builtin#int)




### <a name="Ssa"></a>  [type](nice.go#L49) [Ssa](#Ssa)
#### <a name="Ssa.ssa.AllPackages"></a> [func]() **ssa.AllPackages**() []\*[ssa.Package](//godoc.org/golang.org/x/tools/go/ssa#Package)
#### <a name="Ssa.ssa.Build"></a> [func]() **ssa.Build**()
#### <a name="Ssa.Callgraph"></a> [func](nice.go#L125) **Callgraph**(root \*[ssa.Function](//godoc.org/golang.org/x/tools/go/ssa#Function)) (result \*[rta.Result](//godoc.org/golang.org/x/tools/go/callgraph/rta#Result), err [error](//godoc.org/builtin#error))
#### <a name="Ssa.ssa.ConstValue"></a> [func]() **ssa.ConstValue**(ssa.obj \*[types.Const](//godoc.org/go/types#Const)) \*[ssa.Const](//godoc.org/golang.org/x/tools/go/ssa#Const)
#### <a name="Ssa.ssa.CreatePackage"></a> [func]() **ssa.CreatePackage**(ssa.pkg \*[types.Package](//godoc.org/go/types#Package), ssa.files []\*[ast.File](//godoc.org/go/ast#File), ssa.info \*[types.Info](//godoc.org/go/types#Info), ssa.importable [bool](//godoc.org/builtin#bool)) \*[ssa.Package](//godoc.org/golang.org/x/tools/go/ssa#Package)
#### <a name="Ssa.ssa.CreateTestMainPackage"></a> [func]() **ssa.CreateTestMainPackage**(ssa.pkg \*[ssa.Package](//godoc.org/golang.org/x/tools/go/ssa#Package)) \*[ssa.Package](//godoc.org/golang.org/x/tools/go/ssa#Package)
#### <a name="Ssa.ssa.FuncValue"></a> [func]() **ssa.FuncValue**(ssa.obj \*[types.Func](//godoc.org/go/types#Func)) \*[ssa.Function](//godoc.org/golang.org/x/tools/go/ssa#Function)
#### <a name="Ssa.Functions"></a> [func](nice.go#L56) **Functions**() (fns map[\*[ssa.Function](//godoc.org/golang.org/x/tools/go/ssa#Function)] [bool](//godoc.org/builtin#bool), err [error](//godoc.org/builtin#error))
Returns all the functions contained in the ssa representation of the program.

#### <a name="Ssa.ssa.ImportedPackage"></a> [func]() **ssa.ImportedPackage**(ssa.path [string](//godoc.org/builtin#string)) \*[ssa.Package](//godoc.org/golang.org/x/tools/go/ssa#Package)
#### <a name="Ssa.LocateType"></a> [func](nice.go#L640) **LocateType**(value interface{}) (typ \*[ssa.Type](//godoc.org/golang.org/x/tools/go/ssa#Type), err [error](//godoc.org/builtin#error))
Locate locates a symbol passed to it

#### <a name="Ssa.ssa.LookupMethod"></a> [func]() **ssa.LookupMethod**(ssa.T [types.Type](//godoc.org/go/types#Type), ssa.pkg \*[types.Package](//godoc.org/go/types#Package), ssa.name [string](//godoc.org/builtin#string)) \*[ssa.Function](//godoc.org/golang.org/x/tools/go/ssa#Function)
#### <a name="Ssa.ssa.MethodValue"></a> [func]() **ssa.MethodValue**(ssa.sel \*[types.Selection](//godoc.org/go/types#Selection)) \*[ssa.Function](//godoc.org/golang.org/x/tools/go/ssa#Function)
#### <a name="Ssa.ssa.NewFunction"></a> [func]() **ssa.NewFunction**(ssa.name [string](//godoc.org/builtin#string), ssa.sig \*[types.Signature](//godoc.org/go/types#Signature), ssa.provenance [string](//godoc.org/builtin#string)) \*[ssa.Function](//godoc.org/golang.org/x/tools/go/ssa#Function)
#### <a name="Ssa.NodePos"></a> [func](nice.go#L90) **NodePos**(n [ssa.Node](//godoc.org/golang.org/x/tools/go/ssa#Node)) (pos [token.Pos](//godoc.org/go/token#Pos), err [error](//godoc.org/builtin#error))
#### <a name="Ssa.NodePosition"></a> [func](nice.go#L104) **NodePosition**(n [ssa.Node](//godoc.org/golang.org/x/tools/go/ssa#Node)) (position [token.Position](//godoc.org/go/token#Position), err [error](//godoc.org/builtin#error))
#### <a name="Ssa.ssa.Package"></a> [func]() **ssa.Package**(ssa.obj \*[types.Package](//godoc.org/go/types#Package)) \*[ssa.Package](//godoc.org/golang.org/x/tools/go/ssa#Package)
#### <a name="Ssa.Position"></a> [func](nice.go#L113) **Position**(pos [token.Pos](//godoc.org/go/token#Pos)) (position [token.Position](//godoc.org/go/token#Position), err [error](//godoc.org/builtin#error))
#### <a name="Ssa.ssa.RuntimeTypes"></a> [func]() **ssa.RuntimeTypes**() [][types.Type](//godoc.org/go/types#Type)
#### <a name="Ssa.ValuePos"></a> [func](nice.go#L66) **ValuePos**(v [ssa.Value](//godoc.org/golang.org/x/tools/go/ssa#Value)) (pos [token.Pos](//godoc.org/go/token#Pos), err [error](//godoc.org/builtin#error))
SsaPosition returns the Pos of a given ssa value
it ascends in the ssa graph until it can find a valid position.

#### <a name="Ssa.ValuePosition"></a> [func](nice.go#L81) **ValuePosition**(v [ssa.Value](//godoc.org/golang.org/x/tools/go/ssa#Value)) (position [token.Position](//godoc.org/go/token#Position), err [error](//godoc.org/builtin#error))
#### <a name="Ssa.ssa.VarValue"></a> [func]() **ssa.VarValue**(ssa.obj \*[types.Var](//godoc.org/go/types#Var), ssa.pkg \*[ssa.Package](//godoc.org/golang.org/x/tools/go/ssa#Package), ssa.ref [][ast.Node](//godoc.org/go/ast#Node)) (ssa.value [ssa.Value](//godoc.org/golang.org/x/tools/go/ssa#Value), ssa.isAddr [bool](//godoc.org/builtin#bool))
> struct {  \*[ssa.Program](//godoc.org/golang.org/x/tools/go/ssa#Program) }


Ssa is a helper type exposing single static analysis helper funcitons.
SSA is a high-level form of code analysis.


### <a name="Test"></a>  [func](nice.go#L407) **[Test](#Test)**(t \*[testing.T](//godoc.org/testing#T), nice [Tester](#Tester), pkgs [][string](//godoc.org/builtin#string))



### <a name="TestBulldozingError"></a>  [var](tests.go#L94) [TestBulldozingError](#TestBulldozingError) [testBulldozingError](#testBulldozingError)
> struct {}




### <a name="Tester"></a>  [type](nice.go#L377) [Tester](#Tester)
#### <a name="Tester.NiceTest"></a> [func](nice.go#L378) **NiceTest**(p \*[Program](#Program)) ([Findings](#Findings), [error](//godoc.org/builtin#error))
> interface{
>   **NiceTest**(p \*[Program](#Program)) ([Findings](#Findings), [error](//godoc.org/builtin#error))
> }




### <a name="TesterFunc"></a>  [type](tests.go#L78) [TesterFunc](#TesterFunc)
#### <a name="TesterFunc.NiceTest"></a> [func](tests.go#L92) **NiceTest**(p \*[Program](#Program)) ([Findings](#Findings), [error](//godoc.org/builtin#error))
> \*[Program](#Program) ([Findings](#Findings), [error](//godoc.org/builtin#error))




### <a name="TmpPkg"></a>  [type](tests.go#L17) [TmpPkg](#TmpPkg)
#### <a name="TmpPkg.Ast"></a> [func](nice.go#L477) **Ast**() (program \*[loader.Program](//godoc.org/golang.org/x/tools/go/loader#Program), err [error](//godoc.org/builtin#error))
Ast lazily computes and returns the *loader.Program, which contains information
about the files that make up this Program, the Ast and the go packages they represent.

The package loaded is assumed to be the current working directory (which is the tested
package when invoked by `go test`)

#### <a name="TmpPkg.BuildContext"></a> [func](nice.go#L438) **BuildContext**() (ctx \*[build.Context](//godoc.org/go/build#Context), err [error](//godoc.org/builtin#error))
#### <a name="TmpPkg.CleanPath"></a> [func](nice.go#L248) **CleanPath**(path [string](//godoc.org/builtin#string)) (s [string](//godoc.org/builtin#string), err [error](//godoc.org/builtin#error))
#### <a name="TmpPkg.Close"></a> [func](tests.go#L74) **Close**() [error](//godoc.org/builtin#error)
#### <a name="TmpPkg.Config"></a> [func](nice.go#L454) **Config**() (config \*[loader.Config](//godoc.org/golang.org/x/tools/go/loader#Config), err [error](//godoc.org/builtin#error))
#### <a name="TmpPkg.DumpSsa"></a> [func](tests.go#L38) **DumpSsa**() (ssaDigest [][byte](//godoc.org/builtin#byte), err [error](//godoc.org/builtin#error))
#### <a name="TmpPkg.Get"></a> [func](nice.go#L589) **Get**(args [][string](//godoc.org/builtin#string), paths [][string](//godoc.org/builtin#string)) (err [error](//godoc.org/builtin#error))
Get `go get`s the the given package(s), and `.Import`s them.
Supports triple-dot and other standard package get syntax.

#### <a name="TmpPkg.Import"></a> [func](nice.go#L616) **Import**(paths [][string](//godoc.org/builtin#string)) (err [error](//godoc.org/builtin#error))
#### <a name="TmpPkg.LoadSsa"></a> [func](nice.go#L539) **LoadSsa**() (err [error](//godoc.org/builtin#error))
Ssa loads the single static assignment form of the Program and populates .Ssa
SSA is a high-level static analysis form beyond the AST; see golang.org/x/tools/go/ssa
for more information on this representation.

#### <a name="TmpPkg.MustCleanPath"></a> [func](nice.go#L278) **MustCleanPath**(path [string](//godoc.org/builtin#string)) (s [string](//godoc.org/builtin#string))
#### <a name="TmpPkg.PkgSsa"></a> [func](tests.go#L23) **PkgSsa**() (pkg \*[ssa.Package](//godoc.org/golang.org/x/tools/go/ssa#Package), err [error](//godoc.org/builtin#error))
#### <a name="TmpPkg.TargetPackages"></a> [func](nice.go#L233) **TargetPackages**() (initials [][Package](#Package), err [error](//godoc.org/builtin#error))
TargetPackages returns the corresponding packages for the the Targets of this Program.

#### <a name="TmpPkg.Test"></a> [func](nice.go#L383) **Test**(t \*[testing.T](//godoc.org/testing#T), nice [Tester](#Tester))
> struct {  \*[Program](#Program)  FakePkgPath [string](//godoc.org/builtin#string)  File \*[os.File](//godoc.org/os#File) }



## Imports
[fmt](//godoc.org/fmt)
[bytes](//godoc.org/bytes)
[errors](//godoc.org/errors)
[go/ast](//godoc.org/go/ast)
[go/build](//godoc.org/go/build)
[go/token](//godoc.org/go/token)
[io](//godoc.org/io)
[os](//godoc.org/os)
[os/exec](//godoc.org/os/exec)
[os/user](//godoc.org/os/user)
[path/filepath](//godoc.org/path/filepath)
[reflect](//godoc.org/reflect)
[sort](//godoc.org/sort)
[strings](//godoc.org/strings)
[testing](//godoc.org/testing)
[text/template](//godoc.org/text/template)
[code.justin.tv/tshadwell/nice/progress](//godoc.org/code.justin.tv/tshadwell/nice/progress)
[golang.org/x/tools/go/callgraph/rta](//godoc.org/golang.org/x/tools/go/callgraph/rta)
[golang.org/x/tools/go/loader](//godoc.org/golang.org/x/tools/go/loader)
[golang.org/x/tools/go/ssa](//godoc.org/golang.org/x/tools/go/ssa)
[golang.org/x/tools/go/ssa/ssautil](//godoc.org/golang.org/x/tools/go/ssa/ssautil)
[go/types](//godoc.org/go/types)
[io/ioutil](//godoc.org/io/ioutil)
[net/http](//godoc.org/net/http)
