package nice

import (
	"bytes"
	"go/token"
	"go/types"
	"io"
	"io/ioutil"
	"net/http"
	"os"
	"strings"

	"golang.org/x/tools/go/loader"
	"golang.org/x/tools/go/ssa"
)

type TmpPkg struct {
	*Program
	FakePkgPath string
	File        *os.File
}

func (m TmpPkg) PkgSsa() (pkg *ssa.Package, err error) {
	if err = m.Program.LoadSsa(); err != nil {
		return
	}

	for _, pkg = range m.Ssa.AllPackages() {
		if pkg.Pkg.Name() == m.FakePkgPath {
			return
		}
	}

	panic("cannot locate own pakage?? help")
	return
}

func (m TmpPkg) DumpSsa() (ssaDigest []byte, err error) {
	pkg, err := m.PkgSsa()
	if err != nil {
		return
	}

	var b bytes.Buffer
	ssa.WritePackage(&b, pkg)

	ssaDigest = b.Bytes()
	return
}

func FromString(pkgText string) (m TmpPkg, err error) {

	// 🚮  GARBAGE ZONE 🚮

	if m.File, err = ioutil.TempFile("", "nice-mock-package"); err != nil {
		return
	}

	m.FakePkgPath = "main"

	if _, err = io.Copy(m.File, strings.NewReader(pkgText)); err != nil {
		return
	}

	m.Program = new(Program)

	m.Program.ldcfg = new(loader.Config)

	m.Program.ldcfg.CreateFromFilenames(m.FakePkgPath, m.File.Name())

	return
}

func (m TmpPkg) Close() error { return os.Remove(m.File.Name()) }

var _ ssa.If

type TesterFunc func(*Program) (Findings, error)

type testDescription struct {
	Name        string
	Description string
	Confidence  Confidence
	Severity    Severity
}

func (t testDescription) TestName() string           { return t.Name }
func (t testDescription) TestDescription() string    { return t.Description }
func (t testDescription) TestConfidence() Confidence { return t.Confidence }
func (t testDescription) TestSeverity() Severity     { return t.Severity }

func (t TesterFunc) NiceTest(p *Program) (Findings, error) { return t(p) }

var TestBulldozingError = testBulldozingError{}

type testBulldozingError struct{}

// determines if the given function is like an http.Handler;
// this is based on having (1) a parameter implementing http.ResponseWriter
// and (2) a parameter that takes an *http.Request
func (testBulldozingError) httpHandlerLike(p Ssa, fn *ssa.Function) (ok bool, err error) {
	var r http.ResponseWriter
	var rq http.Request
	responseWriter, err := p.LocateType(&r)
	if err != nil {
		return
	}

	request, err := p.LocateType(&rq)
	if err != nil {
		return
	}

	var haveWriter, haveRequest bool
	for _, param := range fn.Params {
		switch {
		case !haveWriter && types.AssignableTo(param.Type(), responseWriter.Type()):
			haveWriter = true
		case !haveRequest && types.AssignableTo(param.Type(), request.Type()):
			haveRequest = true
		}

		ok = haveWriter && haveRequest
		if ok {
			return
		}
	}

	return
}

func (t testBulldozingError) NiceTest(p *Program) (findings Findings, err error) {
	var description = testDescription{Name: "Test Bulldozing Error", Description: "dont do this", Confidence: HighConfidence, Severity: HighSeverity}

	if err = p.LoadSsa(); err != nil {
		return
	}

	fns, err := p.Ssa.Functions()
	if err != nil {
		return
	}

	for function, _ := range fns {
		var ok bool
		// do we implement http.Handler?
		if ok, err = t.httpHandlerLike(*p.Ssa, function); err != nil {
			return
		}

		if !ok {
			continue
		}

	BlockLoop:
		for blockN, block := range function.Blocks {
			for _, instr := range block.Instrs {
				var ifStmt *ssa.If
				var ok bool
				if ifStmt, ok = instr.(*ssa.If); !ok {
					continue
				}

				var comp *ssa.BinOp
				if comp, ok = ifStmt.Cond.(*ssa.BinOp); !ok {
					continue
				}

				if comp.Op != token.NEQ {
					continue
				}

				xConst, xOk := comp.X.(*ssa.Const)
				yConst, yOk := comp.Y.(*ssa.Const)

				var cnst *ssa.Const
				switch {
				case xOk && xConst.IsNil():
					cnst = xConst
				case yOk && yConst.IsNil():
					cnst = yConst
				default:
					continue
				}

				var namedType *types.Named
				if namedType, ok = cnst.Type().(*types.Named); !ok {
					continue
				}

				o := namedType.Obj()

				// this should probably be a comparison to the
				// error member of the Universe
				if !(o.Parent() == types.Universe && o.Name() == "error") {
					continue
				}

				// so at this point we have an if statment that compares
				// something to a nil error, we should check
				// if we have a return statement here

				// documentation on *ssa.If says:

				// "The If instruction transfers control to one of the
				// two successors of its owning block, depending on the
				// boolean Cond: the first if true, the second if false."

				// so i guess we just check the next Block of the parent

				for _, instruction := range ifStmt.Parent().Blocks[blockN+1].Instrs {
					// TODO: break support?
					if _, ok := instruction.(*ssa.Return); ok {
						continue BlockLoop
					}

				}

				var position token.Position
				position, err = p.Ssa.NodePosition(ifStmt)
				if err != nil {
					return
				}

				// endPos can probably just be the first block (if true)
				/* var endPos token.Position
				endPos, err = p.SsaNodePosition(ifStmt.Parent().Blocks[blockN+2])
				NOTE im not smart enough to make this work
				*/

				// we never found a return, surface this
				findings = append(findings, Finding{
					Position:  [2]token.Position{position, position},
					Describer: description,
				})

			}
		}
	}

	return
}
