#!/bin/bash

# This script is a wrapper around terraform apply.
# It's necessary as it fetches credentials from Sandstorm
# and passes the variable to Terraform so that we don't hardcore credentials

REDIS_PASSWORD_SANDSTORM_KEY=qa-eng/grid-router/production/redis
REDIS_PASSWORD_SANDSTORM_ROLE=arn:aws:iam::734326455073:role/sandstorm/production/templated/role/grid_router
REDIS_PASSWORD=$(AWS_SDK_LOAD_CONFIG=1 AWS_PROFILE=twitch-cape-qe-aws sandstorm get -n --role-arn "$REDIS_PASSWORD_SANDSTORM_ROLE" "$REDIS_PASSWORD_SANDSTORM_KEY")

# Check the exit codes of the above command, make sure it was success
result=$?
case $result in
 127)
 # Was Not Installed
 printf "\n\nERROR! You don't have Sandstorm installed. Please install it via these instructions:\nhttps://wiki.twitch.com/display/SSE/Sandstorm+CLI\n"
 exit 1
 ;;
 0)
 # Do nothing, 0 means success
 ;;
 *)
 # Default statement, something unknown
 printf "\n\nERROR! Unexpected error code: $result\n"
 exit 1
 ;;
esac

if [ -z "$REDIS_PASSWORD" ]; then
  echo "Problem fetching Redis Password from Sandstorm. It was empty. Try running: sandstorm -v"
  exit 1
fi

terraform apply -var "redis_password=$REDIS_PASSWORD" $@
