// VPC Endpoint Private DNS Verification
// The Private DNS was manually added to the VPC Endpoints as we're on an older version of the TF Module
// When the VPC Endpoints get deleted, you can delete this
// The values are from the AWS VPC Service Endpoint Console within the details
resource "aws_route53_record" "vpce_validation_grid_router_dev" {
  zone_id = var.r53_zone_id
  name    = "_jm9ptepxdsbg6m3wfsyr"
  type    = "TXT"
  ttl     = "300"
  records = ["vpce:TkSBAvn1BeVy20ECzcMn"]
}

resource "aws_route53_record" "vpce_validation_grid_router_dev_ato" {
  zone_id = var.r53_zone_id
  name    = "_1hwzjqjes0ffl64zphus"
  type    = "TXT"
  ttl     = "300"
  records = ["vpce:wnFl6VEkIoNI3Cd2NcpF"]
}

resource "aws_route53_record" "vpce_validation_grid_router_prod" {
  zone_id = var.r53_zone_id
  name    = "_t35zmz3k1k7wm2tyoly6"
  type    = "TXT"
  ttl     = "300"
  records = ["vpce:jRvHrvo9MTkU2x5Ob9Dx"]
}

resource "aws_route53_record" "vpce_validation_grid_router_prod_2xl" {
  zone_id = var.r53_zone_id
  name    = "_q93ibcl3s8urq34ytpf3"
  type    = "TXT"
  ttl     = "300"
  records = ["vpce:KGlb77ZRVJXUFyMS7NZY"]
}
