# Health Alarm
resource "aws_cloudwatch_metric_alarm" "env_health" {
  alarm_name          = "${aws_elastic_beanstalk_environment.grid_router.name}-environment-health"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = "1"
  metric_name         = "EnvironmentHealth"
  namespace           = "AWS/ElasticBeanstalk"
  period              = "60"
  statistic           = "Maximum"
  threshold           = var.env_health_threshold
  dimensions = {
    EnvironmentName = aws_elastic_beanstalk_environment.grid_router.name
  }
  alarm_description = "This metric monitors a beanstalk environment's health by healthcode. 0 (Ok), 1 (Info), 5 (Unknown), 10 (No data), 15 (Warning), 20 (Degraded), 25 (Severe)"
  alarm_actions = [var.sns_arn] # Trigger PD Incident
  ok_actions    = [var.sns_arn] # Resolve PD Incident
}

resource "aws_cloudwatch_metric_alarm" "duration_to_find_hub" {
  count               = var.duration_to_find_hub_alarm_enabled ? 1 : 0
  alarm_name          = "${aws_elastic_beanstalk_environment.grid_router.name}-duration-to-find-hub"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = "1"
  metric_name         = "DurationToFindHub"
  namespace           = "CBG"
  period              = "60"
  statistic           = "Maximum"
  threshold           = var.duration_to_find_hub_alarm_threshold
  dimensions = {
    AutoScalingGroupName = "${aws_elastic_beanstalk_environment.grid_router.name}-asg"
  }
  alarm_description = "This metric monitors how long it took to find a hub with available capacity"
  alarm_actions = [var.sns_arn] # Trigger PD Incident
  ok_actions    = [var.sns_arn] # Resolve PD Incident
}
