variable "r53_zone_id" {
  default = "Z3J05KP9FG4N38"
}

resource "aws_route53_record" "xarth_dns" {
  zone_id = var.r53_zone_id
  name    = "api-${var.environment}.browsergrid.xarth.tv"
  type    = "CNAME"
  ttl     = "300"
  records = [aws_elastic_beanstalk_environment.grid_router.cname]
}

output "xarth_dns_name" {
  value = aws_route53_record.xarth_dns.name
}

resource "aws_route53_record" "xarth_dns_nexus" {
  count   = var.nexus_dns_name != "" ? 1 : 0 // create if a nexus hostname was provided
  zone_id = var.r53_zone_id
  name    = "api-${var.environment}-nexus.browsergrid.xarth.tv"
  type    = "CNAME"
  ttl     = "300"
  records = [var.nexus_dns_name]
}
