resource "aws_elasticache_replication_group" "redis" {
  replication_group_id          = "${var.application_name}-${var.environment}"
  replication_group_description = "Redis Database for Grid Router ${var.environment}"
  node_type                     = "cache.r5.large"
  number_cache_clusters         = 1
  port                          = 6379
  security_group_ids            = [data.terraform_remote_state.vpc.outputs.twitch_subnets_sg]
  subnet_group_name             = var.redis_subnet_group
  transit_encryption_enabled    = "true"
  auth_token                    = var.redis_password
}
