# SSL for Grid
resource "aws_acm_certificate" "xarth_cert" {
  count             = var.acm_override_arn == "" ? 1 : 0 // only create if user didn't override the arn. IMPORTANT: IF THIS LINE FAILS IN APPLY, ENSURE THE acm_override_arn CERTIFICATE RESOURCE IS CREATED FIRST, such as terraform apply -target aws_acm_certificate.my_cert
  domain_name       = "api-${var.environment}.browsergrid.xarth.tv"
  validation_method = "DNS"

  tags = {
    Service = "grid"
    Owner   = "reichsta"
  }
}

# DNS Validation for the SSL Above
resource "aws_route53_record" "xarth_cert_validation" {
  count = var.acm_override_arn == "" ? 1 : 0 // only create if user didn't override the arn
  zone_id = var.r53_zone_id
  name = lookup(aws_acm_certificate.xarth_cert[count.index].domain_validation_options[0], "resource_record_name")
  type = lookup(aws_acm_certificate.xarth_cert[count.index].domain_validation_options[0], "resource_record_type")
  ttl     = "10800"
  records = [lookup(aws_acm_certificate.xarth_cert[count.index].domain_validation_options[0], "resource_record_value")]
}

// TODO - Remove this record when all clients can use Nexus Authentication within their frameworks
// This is a temporary way for us to allow clients to onboard to the new Nexus authentication
//   while keeping the existing intact
resource "aws_acm_certificate" "xarth_cert_nexus" {
  count             = var.acm_override_arn == "" ? 1 : 0 // only create if user didn't override the arn. IMPORTANT: IF THIS LINE FAILS IN APPLY, ENSURE THE acm_override_arn CERTIFICATE RESOURCE IS CREATED FIRST, such as terraform apply -target aws_acm_certificate.my_cert
  domain_name       = "api-${var.environment}-nexus.browsergrid.xarth.tv"
  validation_method = "DNS"
  subject_alternative_names = [
    "api-${var.environment}.browsergrid.xarth.tv"
  ]

  tags = {
    Service = "grid"
    Owner   = "reichsta"
  }
}

# DNS Validation for the SSL Above
resource "aws_route53_record" "xarth_cert_validation_nexus" {
  count   = var.acm_override_arn == "" ? 1 : 0 // only create if user didn't override the arn
  zone_id = var.r53_zone_id
  name    = lookup(aws_acm_certificate.xarth_cert_nexus[count.index].domain_validation_options[0], "resource_record_name")
  type    = lookup(aws_acm_certificate.xarth_cert_nexus[count.index].domain_validation_options[0], "resource_record_type")
  ttl     = "10800"
  records = [lookup(aws_acm_certificate.xarth_cert_nexus[count.index].domain_validation_options[0], "resource_record_value")]
}
