variable "redis_password" {}

variable "duration_to_find_hub_alarm_enabled" { // Create an alarm to alert when session wait time increases
  default = true
}

variable "duration_to_find_hub_alarm_threshold" { // In Milliseconds
  default = "30000"
}

# Provide this variable to use your own ACM Cert for the Grid Router environment instead of this module creating one
# IMPORTANT! Terraform may require this resource be created before you provide it as a variable
#   to do so, utilize -target. For example, terraform apply -target aws_acm_certificate.my_cert
#   then run terraform apply and it should work
variable "acm_override_arn" {
  default = ""
}

// Backend instance security groups
variable "instance_security_groups" {
  type = list(string)
  default = []
}

// Subnets to launch Beanstalk Resources In
variable "subnets" {
  type = list(string)
}

variable "service_role" {} // Beanstalk Service Role to use

// Provide this if you've created a Nexus Stack and want to create a Nexus DNS Record
// Optional Variable. If you don't provide it, a nexus dns record won't be created
// Example: nexus-Nexus-1G44W9H79292M-616802512.us-west-2.elb.amazonaws.com
variable "nexus_dns_name" {
  default = ""
}
