# Gather security groups / subnets
data "terraform_remote_state" "vpc" {
  backend = "s3"
  config = {
    profile = "twitch-cape-qe-aws"
    bucket  = "tf-state-qe"
    key     = "tfstate/qe/terraform/vpc"
    region  = "us-west-2"
  }
}

# Create a subnet group to use for redis
resource "aws_elasticache_subnet_group" "redis" {
  name        = "grid-router-redis"
  description = "Subnet for Grid Router's Redis Instances to run in"
  subnet_ids = [data.terraform_remote_state.vpc.outputs.private_a]
}
