resource "aws_sns_topic" "grid_router" {
  name = "grid-router"
}

# Subscribe SNS Topic to PagerDuty
# Allows Incidents to be triaged to PagerDuty
# https://twitchoncall.pagerduty.com/services/PD0GSV9
resource "aws_sns_topic_subscription" "gr_pagerduty" {
  topic_arn              = aws_sns_topic.grid_router.arn
  protocol               = "https"
  endpoint               = "https://events.pagerduty.com/integration/ad87b68ebd9b45ffb4d099121dd84b94/enqueue"
  endpoint_auto_confirms = true
}

output "sns_arn" {
  value = aws_sns_topic.grid_router.arn
}
