# Define the ACM Certificates for Grid
# Not using ACM Alternative Names, as adding a record requires destroying/recreating

variable "r53_zone_id" { # browsergrid.xarth.tv zone, used for SSL DNS Validation
  default = "Z3J05KP9FG4N38"
}

# Create a cert for Production, which includes alternative names
resource "aws_acm_certificate" "grid_prod_cert" {
  domain_name               = "api.browsergrid.xarth.tv"
  subject_alternative_names = ["api-prod.browsergrid.xarth.tv"]
  validation_method = "DNS"

  tags = {
    Service = "grid"
    Owner   = "reichsta"
  }
}

# DNS Validation for the SSL grid_prod_transition_cert
resource "aws_route53_record" "grid_prod_transition_cert_validation" { // api.browsergrid.xarth.tv
  zone_id = var.r53_zone_id
  name = lookup(aws_acm_certificate.grid_prod_cert.domain_validation_options[0], "resource_record_name")
  type = lookup(aws_acm_certificate.grid_prod_cert.domain_validation_options[0], "resource_record_type")
  ttl     = "10800"
  records = [lookup(aws_acm_certificate.grid_prod_cert.domain_validation_options[0], "resource_record_value")]
}
resource "aws_route53_record" "grid_prod_transition_cert_validation_2" { // api-prod.browsergrid.xarth.tv
  zone_id = var.r53_zone_id
  name = lookup(aws_acm_certificate.grid_prod_cert.domain_validation_options[1], "resource_record_name")
  type = lookup(aws_acm_certificate.grid_prod_cert.domain_validation_options[1], "resource_record_type")
  ttl     = "10800"
  records = [lookup(aws_acm_certificate.grid_prod_cert.domain_validation_options[1], "resource_record_value")]
}

# TEMPORARY - For Nexus while clients transition. Create a cert that has a Nexus Record built into it
# Need a new cert as existing ones can't be modified

# Create a cert for Production Nexus, which includes alternative names
resource "aws_acm_certificate" "grid_prod_cert_nexus" {
  domain_name               = "api-prod-nexus.browsergrid.xarth.tv"
  subject_alternative_names = ["api.browsergrid.xarth.tv", "api-prod.browsergrid.xarth.tv"]
  validation_method = "DNS"

  tags = {
    Service = "grid"
    Owner   = "reichsta"
  }
}

# DNS Validation for the SSL Cert above
resource "aws_route53_record" "grid_prod_nexus_cert_validation" { // api-nexus.browsergrid.xarth.tv
  zone_id = var.r53_zone_id
  name    = lookup(aws_acm_certificate.grid_prod_cert_nexus.domain_validation_options[0], "resource_record_name")
  type    = lookup(aws_acm_certificate.grid_prod_cert_nexus.domain_validation_options[0], "resource_record_type")
  ttl     = "10800"
  records = [lookup(aws_acm_certificate.grid_prod_cert_nexus.domain_validation_options[0], "resource_record_value")]
}

# THE BELOW commented out records are already covered in the other grid certificate, so they have been validated
//resource "aws_route53_record" "grid_prod_nexus_cert_validation_2" { // api.browsergrid.xarth.tv
//  zone_id = var.r53_zone_id
//  name    = lookup(aws_acm_certificate.grid_prod_cert_nexus.domain_validation_options[1], "resource_record_name")
//  type    = lookup(aws_acm_certificate.grid_prod_cert_nexus.domain_validation_options[1], "resource_record_type")
//  ttl     = "10800"
//  records = [lookup(aws_acm_certificate.grid_prod_cert_nexus.domain_validation_options[1], "resource_record_value")]
//}
//resource "aws_route53_record" "grid_prod_nexus_cert_validation_3" { // api-prod.browsergrid.xarth.tv
//  zone_id = var.r53_zone_id
//  name    = lookup(aws_acm_certificate.grid_prod_cert_nexus.domain_validation_options[2], "resource_record_name")
//  type    = lookup(aws_acm_certificate.grid_prod_cert_nexus.domain_validation_options[2], "resource_record_type")
//  ttl     = "10800"
//  records = [lookup(aws_acm_certificate.grid_prod_cert_nexus.domain_validation_options[2], "resource_record_value")]
//}
