require_relative 'test_suite'

url1 = 'http://grid-dev.us-west2.justin.tv:80/wd/hub'
url2 = 'http://localhost:8080/wd/hub'

results = {}

puts 'This application is responsible for testing the timings between Direct-To-Hub and GridRouter-To-Hub'
puts 'Results are displayed at the end'
puts "Here we go...\n\n"

# Run the first test suite
t1 = TestSuite.new(url1)
t1.run
results['t1'] = t1.timings

# Run the second test suite
t2 = TestSuite.new(url2)
t2.run
results['t2'] = t2.timings

# Display Results
puts "\n--------------\n"
puts 'Results for each test suite!'
puts "Each command's difference when ran against #{url2}"
puts "--------------\n\n"

results['t1'].each do |key, value|
  t2time = results['t2'][key]
  tDiff = (t2time - value).round(2)
  puts "Time difference for #{key}: #{tDiff}"
end
