require 'selenium-webdriver'
require 'time'

class TestSuite
  attr_reader :timings, :url

  def initialize(url)
    @timings = {}
    @url = url
  end

  def run
    puts "Running test suite against #{url}"
    caps = Selenium::WebDriver::Remote::Capabilities.chrome

    driver = run_command { Selenium::WebDriver.for :remote, url: @url, desired_capabilities: caps }

    begin
      sid = run_command { driver.session_id }
      puts "Assigned Session ID: #{sid}"

      url = 'https://www.twitch.tv'
      puts "Navigating to #{url}"
      run_command { driver.navigate.to 'https://www.twitch.tv' }

      puts 'Grabbing title element'
      title = run_command { driver.title }
      puts "The title: #{title}"

      puts 'Navigating to Directory'
      el = run_command { driver.find_element(:css, '[data-a-target="browse-link"]') }

      el_displayed = run_command { el.displayed? }
      puts "The element is displayed: #{el_displayed}"

      if el_displayed
        puts 'Clicking on element'
        run_command { el.click }

        title = run_command { driver.title }
        puts "The title now: #{title}"
      end
    ensure
      run_command { driver.quit }
    end

    puts "Test Suite Complete"
  end

  private def run_command(&block)
    puts "\tGoing to run command #{block.source_location}"
    t1 = Time.now
    response = block.call
    t2 = Time.now
    total = t2 - t1
    @timings[block.source_location] = total.round(2)
    return response
  end
end