job {
    name 'qe-grid-ui-deploy'
    using 'TEMPLATE-deploy-aws'

    scm {
        git {
            remote {
                github 'qe/grid_ui', 'ssh', 'git.xarth.tv'
                credentials 'git-aws-read-key'
            }
            clean true
        }
    }

    logRotator {
          daysToKeep(90)
    }

    wrappers {
      colorizeOutput(colorMap = 'xterm')
    }

    steps {
      shell """
        |./scripts/deploy_artifacts.sh
      """.stripMargin()
    }

    publishers {
      postBuildTask {
        task('ERROR: Timed out while waiting for command to Complete.', 'exit 1', true)
        task('ERROR: Failed to deploy application.', 'exit 1', true)
      }
    }
}
