#!/bin/bash

set -e # exit on error

applicationName="grid-ui"
version="$GIT_COMMIT"
EB_TIMEOUT="20" # number of minutes before timing out

main() {
  local accountID=$(getEnvironmentAccountID)
  local assumeRoleARN="arn:aws:iam::$accountID:role/jenkins"
  echo "Deploying to Account ID: $accountID using role: $assumeRoleARN"

  assumeRole "$assumeRoleARN"
  eb deploy ${applicationName}-${ENVIRONMENT} --version ${version} --timeout "$EB_TIMEOUT"

  resetAWSCredentials
}

getEnvironmentAccountID() {
  if [ "$ENVIRONMENT" = "dev" ]; then
    echo "280017927569"
#  elif [ "$ENVIRONMENT" = "prod" ]; then
#    echo "276846748787"
  else
    echo "Environment '$ENVIRONMENT' was not recognized"
    exit 1
  fi
}

# Assumes an AWS Role
# @param Account ID to assume
assumeRole() {
  local assumeRoleARN="$1"
  echo "Assuming Role: $assumeRoleARN"
  output=$(aws sts assume-role --role-arn "$assumeRoleARN" --role-session-name "Jenkins-Session")

  if [ $? -ne 0 ]; then
    echo "Error assuming role: $assumeRoleARN"
    exit 1
  fi

  # Set Credentials
  export AWS_ACCESS_KEY_ID=$(echo $output | jq -r '.Credentials.AccessKeyId')
  export AWS_SECRET_ACCESS_KEY=$(echo $output | jq -r '.Credentials.SecretAccessKey')
  export AWS_SESSION_TOKEN=$(echo $output | jq -r '.Credentials.SessionToken')

  aws sts get-caller-identity
}

# Resets AWS Credentials, which helps between assuming roles to ensure your assumed-role isn't assuming another role
resetAWSCredentials() {
  unset AWS_ACCESS_KEY_ID
  unset AWS_SECRET_ACCESS_KEY
  unset AWS_SESSION_TOKEN
}

main
