import axios, {AxiosResponse} from "axios";
import {Hub} from "../components/hubItem";

// Returns all hubs
export const GetHubs = async (EnvironmentURL: string, nexusToken: string): Promise<AxiosResponse> => {
    let headers = GridAPIHeaders(nexusToken)

    return await axios.get(`${EnvironmentURL}/cbg/api/hub/registry`, {headers}).then(response => {
        return response
    })
}

// Pauses a particular hub from accepting new sessions
export const PauseHub = async (EnvironmentURL: string, nexusToken: string, hub: Hub): Promise<void> => {
    let headers = GridAPIHeaders(nexusToken)

    await axios.put(`${EnvironmentURL}/cbg/api/hub/registry/${hub.id}/pause`, {}, {headers})
}

// Unpauses a particular hub from accepting new sessions
export const UnpauseHub = async (EnvironmentURL: string, nexusToken: string, hub: Hub): Promise<void> => {
    let headers = GridAPIHeaders(nexusToken)

    await axios.put(`${EnvironmentURL}/cbg/api/hub/registry/${hub.id}/unpause`, {}, {headers})
}

// Creates a map of headers to send
const GridAPIHeaders = ( nexusToken: string ): {} => {
    let headers: {}

    // if nexusToken is not empty (meaning it's hosted behind nexus), send the auth header
    if (nexusToken !== "") {
        headers = {
            'Authorization': `Bearer ${nexusToken}`,
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'X-Requested-With': 'XMLHttpRequest'
        }
    } else {
        headers = {
            'Accept': 'application/json',
            'Content-Type': 'application/json',
            'X-Requested-With': 'XMLHttpRequest'
        }
    }

    return headers
}
