import * as React from "react"
import { Jumbotron, Container, Row, Col } from "reactstrap";
import "./home.scss"

export default class Home extends React.Component<{}, {}> {
  render() {
    let wikiRootHost = "https://wiki.twitch.com";
    let onboardUrl = wikiRootHost + "/display/QE/Onboarding+-+CBG";
    let docUrl = wikiRootHost + "/display/QE/Selenium+Cross+Browser+Grid";

    return (
        <div id="content">
          <Jumbotron id="home_jumbo">
            <h1 className="display-4">Browser Grid</h1>
            <p className="lead">Cross Browser Selenium Testing for Twitch</p>
            <a href={onboardUrl} className="btn btn-outline-secondary homeBtn">Get Started</a>
            <a href={docUrl} className="btn btn-outline-secondary homeBtn">Documentation</a>
          </Jumbotron>
          <Container>
            <Row>
              <Col>
                <h4>Coverage</h4>
                <p>
                  Sleep at night knowing the features you've built work across the various browsers the Twitch community use
                </p>
              </Col>
              <Col>
                <h4>Scale</h4>
                <p>
                  End to End UI tests are slow. Parallelize across many machines, and get test results faster
                </p>
              </Col>
              <Col>
                <h4>Cost</h4>
                <p>
                  Significantly less expensive than third party providers. Pay for the cost of the infrastructure,
                  discounted for Amazon
                </p>
              </Col>
            </Row>
          </Container>
        </div>
    )
  }
};
